% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_monthly_cases.R
\encoding{UTF-8}
\name{compare_monthly_cases}
\alias{compare_monthly_cases}
\title{Compare Monthly Case Trends across Years / Vergleich monatlicher Falltrends zwischen Jahren}
\usage{
compare_monthly_cases(
  df,
  datum_col,
  value_col,
  group_col = NULL,
  years,
  months,
  granularity = "day",
  agg_fun = "sum",
  shift_month = "none",
  save_plot = FALSE,
  save_path = "."
)
}
\arguments{
\item{df}{Data frame with at least a date and value column. / Data Frame mit Datum und Wert}

\item{datum_col}{Name of the date column.. / Name der Datums-Spalte}

\item{value_col}{Name of the value column. / Name der Wertespalte}

\item{group_col}{Optional grouping variable(s) for faceting. / Optionale Gruppierung}

\item{years}{Vector of years to include. E.g., c(2023, 2024). / Zu vergleichende Jahre}

\item{months}{Vector of months to include (1:12). / Zu vergleichende Monate}

\item{granularity}{Aggregation level: "day" or "week". / Aggregationsebene}

\item{agg_fun}{Aggregation function: "sum", "mean", or "median". / Aggregationsfunktion}

\item{shift_month}{Cross-year adjustment for Dec/Jan: "none", "mth_to_next", "mth_to_prev". / Jahreswechsel-Logik}

\item{save_plot}{Logical. Whether to save the plots as PNG files. / Plots speichern?}

\item{save_path}{Path to folder where plots should be saved. / Speicherpfad}
}
\value{
A list with the following elements:
\describe{
  \item{data}{Aggregated and annotated data frame}
  \item{trend_plot}{Line plot showing daily/weekly trends}
  \item{monthly_trend_plot}{Dot plot by year and month}
  \item{box_plot}{Boxplot comparing distributions across months and years}
  \item{tests}{Result of statistical test (from [run_group_tests()])}
  \item{table}{Frequency table of observations per year}
}
}
\description{
This function compares numeric variables (e.g., new case numbers) across specified months and years.
It supports aggregation by day or ISO week, optional cross-year logic (e.g., combining Dec:Jan),
automated visualization (trend line, dot plot, boxplot), and group-wise faceting.
Statistical tests (e.g., t-test, ANOVA) are automatically selected and executed.
}
\details{
Diese Funktion vergleicht numerische Variablen (z.B. Fallzahlen) ueber ausgewaehlte Monate und Jahre hinweg.
Sie unterstuetzt Aggregation nach Tag oder ISO-Woche, optionale Jahreswechsel-Logik (z.B. Dezember:Januar),
automatische Visualisierung (Linien-, Punkt- und Boxplot) sowie Facetierung nach Gruppenvariablen.
Die passenden statistischen Tests (z.B. t-Test, ANOVA) werden automatisch durchgefuehrt.


Function Behavior and Notes:
- The function compares a numeric variable (e.g., case counts) across selected months and years.
- Aggregation can be done at the "day" or "week" level (ISO week, Monday start).
- When shift_month is set to "mth_to_next" or "mth_to_prev", months like December and January can be merged across year boundaries:
    - "mth_to_next": assigns months to the *next* year group (e.g., Dec 2023 to 2024).
    - "mth_to_prev": assigns monthd to the *previous* year group (e.g., Jan 2024 to 2023).
- All plots (trend_plot, monthly_trend_plot, box_plot) are automatically colored by year and faceted if group_col is provided.
- Statistical tests are performed automatically based on the number of groups (e.g., t.test, Wilcoxon, ANOVA, Kruskal-Wallis).

---

Funktionsverhalten und Hinweise:
- Die Funktion vergleicht eine numerische Variable (z.B. Fallzahlen) ueber Monate und Jahre hinweg.
- Die Aggregation erfolgt auf "day"- oder "week"-Ebene (ISO-Woche, Montag-basiert).
- Mit shift_month = "mth_to_next" oder "mth_to_prev" koennen Monate ueber Jahresgrenzen hinweg zugeordnet werden:
    - "mth_to_next": Monat zum Folgejahr (z.B. Dez. 2023 → 2024)
    - "mth_to_prev": Monat zum Vorjahr (z.B. Jan. 2024 → 2023)
- Alle Plots sind nach Jahr eingefaerbt; bei Angabe von group_col erfolgt eine Facetierung.
- Die geeigneten statistischen Tests werden automatisch ausgewaehlt und durchgefuehrt.

---
}
\examples{
set.seed(123)
test_df <- data.frame(
  datum = seq.Date(from = as.Date("2024-12-15"), to = as.Date("2025-01-20"), by = "day"),
  value = sample(0:50, size = 37, replace = TRUE)
)

compare_monthly_cases(
  df = test_df,
  datum_col = "datum",
  value_col = "value",
  years = c(2024, 2025),
  months = c(12, 1),
  granularity = "day",
  agg_fun = "sum",
  shift_month = "mth_to_next",
  save_plot = FALSE
)

}
\seealso{
[run_group_tests()], [check_continuity_by_window()], [standardize_case_columns()], [infer_value_type()]
}
