% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_distribution_by_granularity.R
\encoding{UTF-8}
\name{compare_distribution_by_granularity}
\alias{compare_distribution_by_granularity}
\title{Compare Normality across Granularity Levels / Vergleich der Normalverteilung je Granularitaet}
\usage{
compare_distribution_by_granularity(
  res_day,
  res_week,
  plot = TRUE,
  save_plot = FALSE,
  save_path = "."
)
}
\arguments{
\item{res_day}{Result object from daily-level analysis. / Ergebnisobjekt der Tagesebene}

\item{res_week}{Result object from weekly-level analysis. / Ergebnisobjekt der Wochenebene}

\item{plot}{Logical. Whether to display QQ plots. / QQ-Plots anzeigen?}

\item{save_plot}{Logical. Whether to save the plot as PNG. / Soll der Plot gespeichert werden?}

\item{save_path}{Folder to save plot. Default is ".". / Speicherpfad fuer den Plot}
}
\value{
A data frame with normality diagnostics for each granularity level.
\describe{
  \item{factor}{Group name(s)}
  \item{granularity}{Data granularity ("day" or "week")}
  \item{shapiro_W}{Shapiro-Wilk W statistic}
  \item{shapiro_p}{p-value of Shapiro-Wilk test}
  \item{normal}{Whether data are considered normal ("ja"/"nein")}
  \item{levene_p}{Levene's test p-value (if available)}
  \item{bartlett_p}{Bartlett's test p-value (if available)}
}
}
\description{
This function compares Shapiro-Wilk normality results between two granularity levels (e.g., daily vs. weekly data).
It extracts diagnostics from test result objects (from [run_paired_tests()], [run_group_tests()] or [run_multi_group_tests()]) and displays them side-by-side.
Optionally, QQ plots are generated to visualize distributional properties.
}
\details{
Diese Funktion vergleicht die Shapiro-Wilk-Ergebnisse der Normalverteilung zwischen zwei Granularitaetsebenen (z.B. Tages- vs. Wochen-Daten).
Diagnosen aus Testergebnissen (z.B. von [run_paired_tests()], [run_group_tests()] oder [run_multi_group_tests()]) werden extrahiert und nebeneinander dargestellt.
Optional werden QQ-Plots erzeugt, um Verteilungen zu visualisieren.
}
\examples{
df <- data.frame(
  datum = seq.Date(from = as.Date("2024-01-01"), by = "day", length.out = 400),
  neue_faelle = rpois(400, lambda = 20)
)
res_day <- compare_monthly_cases(
  df = df,
  datum_col = "datum",
  value_col = "neue_faelle",
  years = c(2024,2025),
  months = 1:2,
  granularity = "day",
  shift_month = "none",
  agg_fun = "sum",
  save_plot = FALSE
)
res_week <- compare_monthly_cases(
  df = df,
  datum_col = "datum",
  value_col = "neue_faelle",
  years = c(2024,2025),
  months = 1:2,
  granularity = "week",
  shift_month = "none",
  agg_fun = "sum",
  save_plot = FALSE
)
compare_distribution_by_granularity(res_day, res_week)

}
\seealso{
[run_paired_tests()], [run_group_tests()], [run_multi_group_tests()], [compare_monthly_cases]
}
