% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QSM2Phylo.R
\name{qsm2phylo3D}
\alias{qsm2phylo3D}
\alias{qsmList2phylo3D}
\title{Convert QSM format to a phylo3D object}
\usage{
qsm2phylo3D(file, version = "2.4.x", setConnection2zero = TRUE)

qsmList2phylo3D(qsm_list, setConnection2zero = TRUE)
}
\arguments{
\item{file}{File name (with path if not located in working directory),
e.g.:\cr
"C:/...path.../myMatlabQSMfile.mat"}

\item{version}{Specifies the version of the treeQSM .mat-file. Available
are \cr
- "2.0" for version 2.0 and
- "2.4.x" for version 2.4.1 and 2.4.2.}

\item{setConnection2zero}{Logical value (default TRUE) indicating if the
width of the edges, which connect two consecutive cylinders, should be
set to zero. If FALSE, then the radius is set to the radius of the
"child" cylinder.}

\item{qsm_list}{List containing the QSM-data, with the attributes
"radius", "length", "start", "axis", "parent" and "extension".}
}
\value{
\code{qsm2phylo3D(file)} A rooted tree in phylo3D format.

\code{qsmList2phylo3D(qsmList)} A rooted tree in phylo3D format.
}
\description{
\code{qsm2phylo3D} - Wrapper function that converts the output .mat-file of
the software treeQSM (version 2.0 or 2.4.x) to a rooted tree in phylo3D
format.

\code{qsmList2phylo3D} - Converts a list containing QSM data to a rooted
tree in phylo3D format.
}
\examples{
mat_file <- system.file("extdata", "exampleQSM.mat",
  package = "treeDbalance"
)
new_phylo <- qsm2phylo3D(file = mat_file)
new_phylo <- qsmList2phylo3D(NULL)
}
\author{
Sophie Kersting
}
