% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{load_config}
\alias{load_config}
\title{Load Trace Config File}
\usage{
load_config(config_file = NULL)
}
\arguments{
\item{config_file}{The file path to a YAML file containing a full list of parameters. If NULL, it will load a default YAML.}
}
\value{
A trace_config object.
}
\description{
Load configuration file that can be passed to individual trace modules.
}
\details{
Use this function to load in a config file for passing to individual trace modules. This is only required if creating a custom pipeline rather than the main function. This provides a central place to adjust parameters for the pipeline. Either edit the YAML directly, or modify the object (which is basically just a list).

Use the following command to make a copy of the YAML file: \code{file.copy(system.file("extdata/trace_config.yaml", package = "trace"), ".")}.
}
\examples{

config <- load_config()

}
