% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create_cv_folds}
\alias{create_cv_folds}
\title{Create Cross-Validation Folds for a Dissimilarity Matrix}
\usage{
create_cv_folds(
  dissimilarity_matrix,
  ground_truth_matrix = NULL,
  n_folds = 10,
  random_seed = NULL
)
}
\arguments{
\item{dissimilarity_matrix}{The input dissimilarity matrix, which may contain noise.}

\item{ground_truth_matrix}{An optional, noise-free dissimilarity matrix to be used as the ground truth for evaluation. If \code{NULL}, the input \code{dissimilarity_matrix} is used as the truth.}

\item{n_folds}{The integer number of folds to create.}

\item{random_seed}{An optional integer to set the random seed for reproducibility.}
}
\value{
A list of length \code{n_folds}. Each element of the list is itself a list
containing two matrices: \code{truth} (the ground truth for that fold) and \code{train}
(the training matrix with \code{NA} values for validation).
}
\description{
Creates k-fold cross-validation splits from a dissimilarity matrix while maintaining
symmetry. Each fold in the output consists of a training matrix (with some
values masked as \code{NA}) and a corresponding ground truth matrix for validation.
}
\note{
This function has breaking changes from previous versions:
\itemize{
\item Parameter \code{truth_matrix} renamed to \code{dissimilarity_matrix}
\item Parameter \code{no_noise_truth} renamed to \code{ground_truth_matrix}
\item Return structure now uses named elements (\code{$truth}, \code{$train})
}
}
\examples{
# Create a sample dissimilarity matrix
d_mat <- matrix(runif(100), 10, 10)
diag(d_mat) <- 0

# Create 5-fold cross-validation splits
folds <- create_cv_folds(d_mat, n_folds = 5, random_seed = 123)
}
