% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.tna_reliability}
\alias{print.tna_reliability}
\title{Print Reliability Analysis Results}
\usage{
\method{print}{tna_reliability}(x, summary_metrics, ...)
}
\arguments{
\item{x}{A \code{tna_reliability} object.}

\item{summary_metrics}{A \code{character} vector of metrics to display.}

\item{...}{Arguments passed to the generic \code{print} method.}
}
\value{
\code{x} (invisibly).
}
\description{
Print Reliability Analysis Results
}
\examples{
# Small number of iterations for CRAN
model <- tna(engagement)
rel <- reliability(model, iter = 20)
print(rel)

}
\seealso{
Validation functions
\code{\link{bootstrap}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{permutation_test}()},
\code{\link{permutation_test.group_tna}()},
\code{\link{plot.group_tna_bootstrap}()},
\code{\link{plot.group_tna_permutation}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot.tna_bootstrap}()},
\code{\link{plot.tna_permutation}()},
\code{\link{plot.tna_reliability}()},
\code{\link{plot.tna_stability}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_permutation}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{print.summary.tna_bootstrap}()},
\code{\link{print.tna_bootstrap}()},
\code{\link{print.tna_clustering}()},
\code{\link{print.tna_permutation}()},
\code{\link{print.tna_stability}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{reliability}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna_bootstrap}()},
\code{\link{summary.tna_bootstrap}()}
}
\concept{validation}
