% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{tind-package}
\alias{tind-package}
\title{A Common Representation of Time Indices of Different Types}
\description{
The goal of \pkg{tind} project is to provide users with a \emph{single}
class capable of representing time indices of different types.
Currently, these include: years, quarters, months, ISO 8601 weeks, dates,
time of day, date-time, and arbitrary integer/numeric indices.
\pkg{tind} provides a unified interface and a collection of methods, which
can be used with all supported index types.

The package provides an extensive collection of functions for calendrical
computations (including business applications), index conversions,
index parsing, and other operations. Examples of use of \pkg{tind}
functions and methods can be found in their documentation and in package vignettes.

All routines have been optimised for speed in order to facilitate computations
on large datasets.
}
\details{
\strong{Options Controlling \pkg{tind} Behaviour}

\code{tind.abbr.year.start} is a number in range 0--99 determining how
two-digit years are interpreted during parsing. By default (69), two-digit
numbers smaller than 69 are interpreted as years in 2000s and equal or greater
than 69 as years in 1900s.

\code{tind.warn.diff.tz} is a logical value (\code{TRUE} by default)
determining whether warnings should be raised when performing computations
involving date-time indices with different time zone attributes.

\strong{Implementation}

The code structure is hierarchical by design. The first layer consists
of low-level C and R functions working with particular time index types
and converting between them. The second layer consists of exported
(user-accessible) functions, which are responsible for argument checks
and dispatching to the 1st layer functions.

Computations with \pkg{tind} for types other than date-time are
implemented in C from scratch. Many algorithms were taken
from \emph{Calendar FAQ} by Claus Tøndering. For date-time computations,
\pkg{tind} partially relies on base R infrastructure (\code{\link[base]{POSIXlt}}
class), that is on conversion \code{as.POSIXlt.numeric}.
}
\references{
Claus Tøndering, \emph{Calendar FAQ}, \url{https://www.tondering.dk/claus/calendar.html}.
}
\author{
Grzegorz Klima <dever@post.pl>
}
\keyword{package}
