% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_wikipedia_page_links.R
\name{tw_write_wikipedia_page_links_to_cache}
\alias{tw_write_wikipedia_page_links_to_cache}
\title{Write Wikipedia page links to cache}
\usage{
tw_write_wikipedia_page_links_to_cache(
  df,
  language = tidywikidatar::tw_get_language(),
  cache = NULL,
  overwrite_cache = FALSE,
  cache_connection = NULL,
  disconnect_db = TRUE
)
}
\arguments{
\item{df}{A data frame typically generated with
\code{\link[=tw_get_wikipedia_page_links]{tw_get_wikipedia_page_links()}}.}

\item{language}{Two-letter language code used to define the Wikipedia version
to use. Defaults to language set with \code{\link[=tw_set_language]{tw_set_language()}}; if not set,
"en". If url given, this can be left empty.}

\item{cache}{Defaults to \code{NULL}. If given, it should be given either \code{TRUE}
or \code{FALSE}. Typically set with \code{\link[=tw_enable_cache]{tw_enable_cache()}} or \code{\link[=tw_disable_cache]{tw_disable_cache()}}.}

\item{overwrite_cache}{Logical, defaults to \code{FALSE}. If \code{TRUE}, it overwrites
the table in the local sqlite database. Useful if the original Wikidata
object has been updated.}

\item{cache_connection}{Defaults to \code{NULL}. If \code{NULL}, and caching is
enabled, \code{tidywikidatar} will use a local sqlite database. A custom
connection to other databases can be given (see vignette \code{caching} for
details).}

\item{disconnect_db}{Defaults to \code{TRUE}. If \code{FALSE}, leaves the connection to
cache open.}
}
\value{
Silently returns the same data frame provided as input. Mostly used
internally for its side effects.
}
\description{
Mostly used internally by \code{tidywikidatar}, use with caution to keep caching
consistent.
}
\examples{
if (interactive()) {
  df <- tw_get_wikipedia_page_links(
    title = "Margaret Mead",
    language = "en",
    cache = FALSE
  )

  tw_write_wikipedia_page_links_to_cache(
    df = df,
    language = "en"
  )
}
}
