% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_image.R
\name{tw_get_image_same_length}
\alias{tw_get_image_same_length}
\title{Get image from Wikimedia Commons}
\usage{
tw_get_image_same_length(
  id,
  format = "filename",
  as_tibble = FALSE,
  only_first = TRUE,
  width = NULL,
  language = tidywikidatar::tw_get_language(),
  id_df = NULL,
  cache = NULL,
  overwrite_cache = FALSE,
  cache_connection = NULL,
  disconnect_db = TRUE,
  wait = 0
)
}
\arguments{
\item{id}{A character vector of length 1, must start with Q, e.g. "Q254" for
Wolfgang Amadeus Mozart.}

\item{format}{A character vector, defaults to \code{filename}. If set to
\code{commons}, outputs the link to the Wikimedia Commons page. If set to
\code{embed}, outputs a link that can be used to embed.}

\item{as_tibble}{Defaults to \code{FALSE}. If \code{TRUE}, returns a data frame instead
of a character vector.}

\item{only_first}{Defaults to \code{TRUE}. If \code{TRUE}, returns only the first image
associated with a given Wikidata id. If \code{FALSE}, returns all images
available.}

\item{width}{A numeric value, defaults to \code{NULL}, relevant only if format is
set to 'embed'. If not given, defaults to full resolution image.}

\item{language}{Defaults to language set with \code{\link[=tw_set_language]{tw_set_language()}}; if not
set, "en". Use "all_available" to keep all languages. For available
language values, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{the
dedicated Wikimedia page}.}

\item{id_df}{Default to NULL. If given, it should be a dataframe typically
generated with \code{\link[=tw_get]{tw_get()}}, and is used instead of calling Wikidata or
using SQLite cache. Ignored when \code{id} is of length more than one.}

\item{cache}{Defaults to \code{NULL}. If given, it should be given either \code{TRUE}
or \code{FALSE}. Typically set with \code{\link[=tw_enable_cache]{tw_enable_cache()}} or \code{\link[=tw_disable_cache]{tw_disable_cache()}}.}

\item{overwrite_cache}{Logical, defaults to \code{FALSE}. If \code{TRUE}, it overwrites
the table in the local sqlite database. Useful if the original Wikidata
object has been updated.}

\item{cache_connection}{Defaults to \code{NULL}. If \code{NULL}, and caching is
enabled, \code{tidywikidatar} will use a local sqlite database. A custom
connection to other databases can be given (see vignette \code{caching} for
details).}

\item{disconnect_db}{Defaults to \code{TRUE}. If \code{FALSE}, leaves the connection to
cache open.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to
Wikidata. If data are cached locally, wait time is not applied. If you are
running many queries systematically you may want to add some waiting time
between queries.}
}
\value{
A character vector, corresponding to reference to the image in the
requested format.
}
\description{
Please consult the
\href{https://commons.wikimedia.org/wiki/Commons:Reusing_content_outside_Wikimedia/technical}{relevant
documentation for reusing content outside Wikimedia}.
}
\examples{
tw_get_image_same_length("Q180099",
  format = "filename"
)

if (interactive()) {
  tw_get_image_same_length("Q180099",
    format = "commons"
  )

  tw_get_image_same_length("Q180099",
    format = "embed",
    width = 300
  )
}
}
