% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presynth.R
\name{update_presynth}
\alias{update_presynth}
\title{Update \code{presynth} object}
\usage{
update_presynth(presynth, roadmap = NULL, synth_spec = NULL)
}
\arguments{
\item{presynth}{A \code{presynth} object}

\item{roadmap}{An optional \code{roadmap} object}

\item{synth_spec}{An optional \code{synth_spec} object}
}
\value{
A \code{presynth} object.
}
\description{
Update \code{presynth} object
}
\examples{

# create roadmap
rm <- roadmap(
  conf_data = acs_conf_nw,
  start_data = acs_start_nw
) 

rpart_mod_reg <- parsnip::decision_tree() |>
  parsnip::set_engine(engine = "rpart") |>
  parsnip::set_mode(mode = "regression")

rpart_mod_class <- parsnip::decision_tree() |>
  parsnip::set_engine(engine = "rpart") |>
  parsnip::set_mode(mode = "classification")

synth_spec1 <- synth_spec(
  default_regression_model = rpart_mod_reg,
  default_regression_sampler = sample_rpart,
  default_classification_model = rpart_mod_class,
  default_classification_sampler = sample_rpart
)

# create a presynth object
# use defaults for noise, constraints, and replicates
presynth <- presynth(
  roadmap = rm,
  synth_spec = synth_spec1
)

lm_mod <- parsnip::linear_reg() |>
  parsnip::set_engine(engine = "lm") |>
  parsnip::set_mode(mode = "regression")

synth_spec2 <- synth_spec(
  default_regression_model = lm_mod,
  default_regression_sampler = sample_lm,
  default_classification_model = rpart_mod_class,
  default_classification_sampler = sample_rpart
)

}
