% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_loci_table_ordered.R
\name{is_loci_table_ordered}
\alias{is_loci_table_ordered}
\alias{is_loci_table_ordered.tbl_df}
\alias{is_loci_table_ordered.vctrs_bigSNP}
\title{Test if the loci table is ordered}
\usage{
is_loci_table_ordered(
  .x,
  error_on_false = FALSE,
  ignore_genetic_dist = TRUE,
  ...
)

\method{is_loci_table_ordered}{tbl_df}(
  .x,
  error_on_false = FALSE,
  ignore_genetic_dist = TRUE,
  ...
)

\method{is_loci_table_ordered}{vctrs_bigSNP}(
  .x,
  error_on_false = FALSE,
  ignore_genetic_dist = TRUE,
  ...
)
}
\arguments{
\item{.x}{a vector of class \code{vctrs_bigSNP} (usually the \code{genotype} column of
a \code{\link{gen_tibble}} object), or a \code{\link{gen_tibble}}.}

\item{error_on_false}{logical, if \code{TRUE} an error is thrown if the loci are
not ordered.}

\item{ignore_genetic_dist}{logical, if \code{TRUE} the physical position is not
checked.}

\item{...}{other arguments passed to specific methods.}
}
\value{
a logical vector defining which loci are transversions
}
\description{
This functions checks that all SNPs in a chromosome are adjacent in the loci
table, and that positions are sorted within chromosomes.
}
\examples{
example_gt <- load_example_gt("gen_tbl")

example_gt \%>\% is_loci_table_ordered()

}
