% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_from_genlight.R
\name{gt_from_genlight}
\alias{gt_from_genlight}
\title{Convert a \code{genlight} object from adegenet to a \code{gen_tibble}}
\usage{
gt_from_genlight(x, backingfile = NULL, ...)
}
\arguments{
\item{x}{A \code{genlight} object}

\item{backingfile}{the path, including the file name without extension, for
backing files used to store the data (they will be given a .bk and .rds
automatically). If \code{NULL} (default), backing files are placed in the
temporary directory.}

\item{...}{Additional arguments passed to gen_tibble().}
}
\value{
A \code{gen_tibble} object
}
\description{
This function converts a \code{genlight} object from the \code{adegenet} package to a
\code{gen_tibble} object
}
\details{
\itemize{
\item Currently supports diploid \code{genlight} objects only (all values in
\verb{@ploidy} must be 2).
\item Requires non-missing slots: \code{loc.names}, \code{n.loc}, \code{loc.all}, \code{chromosome},
\code{position}, \code{ploidy}, \code{ind.names}. The \code{pop} slot is optional; if absent, the
returned gen_tibble will omit the population column.
}
}
\examples{
\dontshow{if (rlang::is_installed("adegenet")) withAutoprint(\{ # examplesIf}

# Create a simple genlight object
x <- new("genlight",
  list(
    indiv1 = c(1, 1, 0, 1, 1, 0),
    indiv2 = c(2, 1, 1, 0, 0, 0)
  ),
  ploidy = c(2, 2),
  loc.names = paste0("locus", 1:6),
  chromosome = c("chr1", "chr1", "chr2", "chr2", "chr3", "chr3"),
  position = c(100, 200, 150, 250, 300, 400),
  loc.all = c("A/T", "C/G", "G/C", "A/T", "T/C", "G/A"),
  pop = c("pop1", "pop2")
)


file <- paste0(tempfile(), "gt_from_genlight")
# Convert to gen_tibble
new_gt <- gt_from_genlight(x, backingfile = file)
\dontshow{\}) # examplesIf}
}
