% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{tl_semisupervised}
\alias{tl_semisupervised}
\title{Semi-Supervised Learning via Clustering}
\usage{
tl_semisupervised(
  data,
  formula,
  labeled_indices,
  cluster_method = "kmeans",
  supervised_method = "logistic",
  ...
)
}
\arguments{
\item{data}{A data frame}

\item{formula}{Model formula}

\item{labeled_indices}{Indices of labeled observations}

\item{cluster_method}{Clustering method for label propagation}

\item{supervised_method}{Supervised learning method for final model}

\item{...}{Additional arguments}
}
\value{
A tidylearn model trained on pseudo-labeled data
}
\description{
Train a supervised model with limited labels by first clustering the data
and propagating labels within clusters.
}
\examples{
\donttest{
# Use only 10\% of labels
labeled_idx <- sample(nrow(iris), size = 15)
model <- tl_semisupervised(iris, Species ~ ., labeled_indices = labeled_idx,
                           cluster_method = "kmeans", supervised_method = "logistic")
}
}
