% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supervised-regularization.R
\name{tl_fit_lasso}
\alias{tl_fit_lasso}
\title{Fit a Lasso regression model}
\usage{
tl_fit_lasso(
  data,
  formula,
  is_classification = FALSE,
  alpha = 1,
  lambda = NULL,
  cv_folds = 5,
  ...
)
}
\arguments{
\item{data}{A data frame containing the training data}

\item{formula}{A formula specifying the model}

\item{is_classification}{Logical indicating if this is a classification problem}

\item{alpha}{Mixing parameter (0 for Ridge, 1 for Lasso, between 0-1 for Elastic Net)}

\item{lambda}{Regularization parameter (if NULL, uses cross-validation to select)}

\item{cv_folds}{Number of folds for cross-validation (default: 5)}

\item{...}{Additional arguments to pass to glmnet()}
}
\value{
A fitted Lasso regression model
}
\description{
Fit a Lasso regression model
}
\keyword{internal}
