% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supervised-regularization.R
\name{tl_fit_elastic_net}
\alias{tl_fit_elastic_net}
\title{Fit an Elastic Net regression model}
\usage{
tl_fit_elastic_net(
  data,
  formula,
  is_classification = FALSE,
  alpha = 0.5,
  lambda = NULL,
  cv_folds = 5,
  ...
)
}
\arguments{
\item{data}{A data frame containing the training data}

\item{formula}{A formula specifying the model}

\item{is_classification}{Logical indicating if this is a classification problem}

\item{alpha}{Mixing parameter (default: 0.5 for Elastic Net)}

\item{lambda}{Regularization parameter (if NULL, uses cross-validation to select)}

\item{cv_folds}{Number of folds for cross-validation (default: 5)}

\item{...}{Additional arguments to pass to glmnet()}
}
\value{
A fitted Elastic Net regression model
}
\description{
Fit an Elastic Net regression model
}
\keyword{internal}
