% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised-dbscan.R
\name{suggest_eps}
\alias{suggest_eps}
\title{Suggest eps Parameter for DBSCAN}
\usage{
suggest_eps(data, minPts = 5, method = "percentile", percentile = 0.95)
}
\arguments{
\item{data}{A data frame or matrix}

\item{minPts}{Minimum points parameter (used as k for k-NN)}

\item{method}{Method to suggest eps: "knee" (default), "percentile"}

\item{percentile}{If method="percentile", which percentile to use (default: 0.95)}
}
\value{
A list containing:
\itemize{
\item eps: suggested epsilon value
\item knn_distances: full tibble of k-NN distances
\item method: method used
}
}
\description{
Use k-NN distance plot to suggest eps value
}
\examples{
eps_info <- suggest_eps(iris, minPts = 5)
eps_info$eps

}
