% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{categorize_scale}
\alias{categorize_scale}
\title{Categorize numeric variables into categories}
\usage{
categorize_scale(
  data,
  ...,
  breaks,
  labels,
  lower_end = NULL,
  upper_end = NULL,
  name = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{data}{A tibble or a tdcmm model.}

\item{...}{Variables to recode as factor variables in categories.
If no variables are specified, all numeric columns will be recoded.}

\item{breaks}{A vector of numeric values specifying the breaks for
categorizing the data between the lower and upper ends.
The breaks define the boundaries of the intervals. Setting this parameter is
required.}

\item{labels}{A vector of string labels for each interval. The number of
labels must match the number of intervals defined by the breaks and
lower/upper ends.Setting this parameter is required.}

\item{lower_end}{Optional numeric value specifying the lower end of the scale.
If not provided, defaults to the minimum value of the data.}

\item{upper_end}{Optional numeric value specifying the upper end of
the scale. If not provided, defaults to the maximum value of the data.}

\item{name}{Optional string specifying the name of the new variable(s).
By default, the new variable names are the original variable names suffixed
with \verb{_cat}.}

\item{overwrite}{Logical indicating whether to overwrite the original
variable(s) with the new categorical variables. If \code{TRUE},
the original variable(s) are overwritten.}
}
\value{
A modified tibble or tdcmm model with the recoded variables.
}
\description{
This function recodes one or more numeric variables into categorical
variables based on a specified lower end, upper end, and intermediate breaks.
The intervals created include the right endpoint of the interval. For example,
breaks = c(2, 3) with lower_end = 1 and upper_end = 5 creates intervals from
1 to <= 2, >2 to <= 3, and >3 to <= 5. If the lower or upper ends are not provided,
the function defaults to the minimum and maximum values of the data and issues
a warning. This default behavior is prone to errors, however, because a scale may not
include its actual lower and upper ends which might in turn affect the recoding
process. Hence, it is strongly suggested to manually set the lower and upper
bounds of the original continuous scale.
}
\examples{
WoJ \%>\%
dplyr::select(trust_parliament, trust_politicians) \%>\%
categorize_scale(trust_parliament, trust_politicians,
lower_end = 1, upper_end = 5, breaks = c(2, 3),
labels = c("Low", "Medium", "High"), overwrite = FALSE)
WoJ \%>\%
dplyr::select(autonomy_selection) \%>\%
categorize_scale(autonomy_selection, breaks = c(2, 3, 4),
lower_end = 1, upper_end = 5,
labels = c("Low", "Medium", "High", "Very High"),
name = "autonomy_in_categories")
}
\seealso{
Other scaling: 
\code{\link{center_scale}()},
\code{\link{dummify_scale}()},
\code{\link{minmax_scale}()},
\code{\link{recode_cat_scale}()},
\code{\link{reverse_scale}()},
\code{\link{setna_scale}()},
\code{\link{z_scale}()}
}
\concept{scaling}
