% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-diagnostics.R
\name{filter_keep}
\alias{filter_keep}
\alias{filter_keep.data.frame}
\title{Filter Data with Diagnostic Statistics (Keep)}
\usage{
filter_keep(.data, ...)

\method{filter_keep}{data.frame}(.data, ..., .stat = NULL, .quiet = FALSE, .warn_threshold = NULL)
}
\arguments{
\item{.data}{A data.frame, tibble, or other object.}

\item{...}{Filter conditions, evaluated in the context of \code{.data} using
tidy evaluation (same as \code{\link[dplyr:filter]{dplyr::filter()}}).}

\item{.stat}{An unquoted column or expression to total, e.g., \code{amount},
\code{price * qty}. Reports the amount dropped and its share of the total.}

\item{.quiet}{Logical. If \code{TRUE}, suppress printing diagnostics.}

\item{.warn_threshold}{Numeric between 0 and 1. If set and the proportion of
dropped rows exceeds this threshold, a warning is issued.}
}
\value{
The filtered data.frame or tibble.
}
\description{
Filters a data.frame or tibble while reporting statistics about dropped rows
and optionally the sum of a statistic column that was dropped. Keeps rows
where the conditions are TRUE (same as \code{\link[dplyr:filter]{dplyr::filter()}}).
}
\section{Methods (by class)}{
\itemize{
\item \code{filter_keep(data.frame)}: Method for data.frame objects

}}
\examples{
df <- data.frame(
  id = 1:6,
  keep = c(TRUE, FALSE, TRUE, NA, TRUE, FALSE),
  sales = c(100, 50, 200, 25, NA, 75)
)
filter_keep(df, keep == TRUE)
filter_keep(df, keep == TRUE, .stat = sales)

}
\seealso{
Other filter diagnostics: 
\code{\link{filter_drop}()}
}
\concept{filter diagnostics}
