% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syntax-estimate.R
\name{estimate_mplus}
\alias{estimate_mplus}
\title{Estimate tidy_sem using 'Mplus'}
\usage{
estimate_mplus(x, ...)
}
\arguments{
\item{x}{An object of class \code{tidy_sem}.}

\item{...}{Additional parameters passed to
\code{\link[MplusAutomation]{mplusObject}} and
\code{\link[MplusAutomation]{mplusModeler}}. These arguments are matched to
the correct function by name. The arguments \code{rdata}, and \code{MODEL}
cannot be edited, as they are determined from the \code{tidy_sem} object.}
}
\value{
An object of class \code{mplusObject}.
}
\description{
This function is a wrapper for the functions
\code{\link[MplusAutomation]{mplusObject}} and
\code{\link[MplusAutomation]{mplusModeler}}. Using this function requires
'Mplus' to be installed.
}
\details{
The arguments \code{dataout}, \code{modelout}, and \code{run} are
optional. If these are not specified, the model will be run in
\code{\link{tempdir}}.
}
\examples{
library(MplusAutomation)
model <- tidy_sem(iris, "\\\\.")
model <- measurement(model)
\dontrun{
  estimate_mplus(model, run = 0L)
}
}
