% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlp_tokenize_text.R
\name{nlp_tokenize_text}
\alias{nlp_tokenize_text}
\title{Tokenize Text Data (mostly) Non-Destructively}
\usage{
nlp_tokenize_text(
  corpus,
  by = c("doc_id", "paragraph_id", "sentence_id"),
  include_spans = TRUE,
  method = "word"
)
}
\arguments{
\item{corpus}{A data frame or data.table containing a \code{text} column and the identifiers specified in \code{by}.}

\item{by}{A character vector of column names used as unique identifiers.
The last column determines the search unit (e.g., if \code{by = c("doc_id", "para_id")},
the search returns matches at the paragraph level).}

\item{include_spans}{Logical. Include start/end character spans for each token.}

\item{method}{Character. \code{"word"} or \code{"biber"}.}
}
\value{
A named list of tokens (or list of \code{tokens} and \code{spans} if \code{include_spans = TRUE}).
}
\description{
Tokenizes text from a corpus data frame, preserving structure like capitalization and punctuation.
}
\examples{
corpus <- data.frame(doc_id = c('1', '1', '2'),
                    sentence_id = c('1', '2', '1'),
                    text = c("Hello world.",
                             "This is an example.",
                             "This is a party!"))
tokens <- nlp_tokenize_text(corpus, by = c('doc_id', 'sentence_id'))
}
