% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/like_inference.R
\name{mle_from_holq}
\alias{mle_from_holq}
\title{Get MLE from output of \code{holq}.}
\usage{
mle_from_holq(holq_obj)
}
\arguments{
\item{holq_obj}{The output returned from \code{holq}.}
}
\value{
\code{cov_mle} A list of positive definite matrices. These
    are the MLEs for the component covariance matrices.

  \code{sig_mle} A numeric. This is an estimate of the "standard
  deviation" form of the total variation parameter.
}
\description{
From the output of \code{holq}, this function will calculate the
MLEs for the component covariance matrices and for the total
variation parameter.
}
\details{
The function simply takes the \code{A[[i]]} output of \code{holq}
and returs \code{A[[i]] \%*\% t(A[[i]])}. The estimate of the total
variation parameter is \code{sqrt(sig ^ 2 / prod{p})}, whre \code{p} is the
vector of dimensions of the data array and \code{sig} is the output
from \code{holq}.
}
\references{
\itemize{
  \item{Gerard, D., & Hoff, P. (2016). A higher-order LQ decomposition for separable covariance models. \emph{Linear Algebra and its Applications}, 505, 57-84. \doi{10.1016/j.laa.2016.04.033}}
}
}
\seealso{
\code{\link{holq}}.
}
\author{
David Gerard.
}
\keyword{likelihood}
