% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bot.R
\name{sendChatAction}
\alias{sendChatAction}
\title{Send a chat action}
\usage{
sendChatAction(chat_id, action)
}
\arguments{
\item{chat_id}{Unique identifier for the target chat or username of
the target channel.}

\item{action}{Type of action to broadcast. Choose one, depending on
what the user is about to receive:
\describe{
 \item{\code{typing}}{ for text messages}
 \item{\code{upload_photo}}{ for photos}
 \item{\code{upload_video}}{ for videos}
 \item{\code{record_video}}{ for video recording}
 \item{\code{upload_audio}}{ for audio files}
 \item{\code{record_audio}}{ for audio file recording}
 \item{\code{upload_document}}{ for general files}
 \item{\code{find_location}}{ for location data}
 \item{\code{upload_video_note}}{ for video notes}
 \item{\code{record_video_note}}{ for video note recording}
}}
}
\description{
Use this method when you need to tell the user that something is happening
on the bot's side. The status is set for 5 seconds or less (when a message
arrives from your bot, Telegram clients clear its typing status).
}
\details{
You can also use it's snake_case equivalent \code{send_chat_action}.
}
\examples{
\dontrun{
bot <- Bot(token = bot_token("RTelegramBot"))
chat_id <- user_id("Me")

bot$sendChatAction(
  chat_id = chat_id,
  action = "typing"
)
}
}
