% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tleaves.R
\name{.get_ps}
\alias{.get_ps}
\title{Saturation water vapour pressure (kPa)}
\usage{
.get_ps(Temp, P, unitless)
}
\arguments{
\item{Temp}{Temperature in Kelvin}

\item{P}{Atmospheric pressure in kPa}

\item{unitless}{Logical. Should function use parameters with \code{units}? The function is faster when FALSE, but input must be in correct units or else results will be incorrect without any warning.}
}
\value{
Value in kPa of class \code{units}
}
\description{
Saturation water vapour pressure (kPa)
}
\details{
Goff-Gratch equation (see https://cires1.colorado.edu/~voemel/vp.html) \cr
\cr
This equation assumes P = 1 atm = 101.3246 kPa, otherwise boiling temperature needs to change \cr
}
\examples{

T_leaf <- set_units(298.15, K)
P <- set_units(101.3246, kPa)
tealeaves:::.get_ps(T_leaf, P, FALSE)

}
\references{
\url{https://cires1.colorado.edu/~voemel/vp.html}
}
