% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reporter.R
\docType{class}
\name{Reporter}
\alias{Reporter}
\title{\code{Reporter}: An \code{R6} class for managing report cards}
\description{
This \code{R6} class is designed to store and manage report cards,
facilitating the creation, manipulation, and serialization of report-related data.
}
\note{
The function has to be used in the shiny reactive context.

if Report has an id when converting to JSON then It will be compared to the currently available one.

if Report has an id when converting to JSON then It will be compared to the currently available one.
}
\examples{
\dontshow{if (require("ggplot2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(ggplot2)
library(rtables)

card1 <- ReportCard$new()

card1$append_text("Header 2 text", "header2")
card1$append_text("A paragraph of default text")
card1$append_plot(
  ggplot(iris, aes(x = Petal.Length)) + geom_histogram()
)

card2 <- ReportCard$new()

card2$append_text("Header 2 text", "header2")
card2$append_text("A paragraph of default text")
lyt <- analyze(split_rows_by(basic_table(), "Day"), "Ozone", afun = mean)
table_res2 <- build_table(lyt, airquality)
card2$append_table(table_res2)

reporter <- Reporter$new()
reporter$append_cards(list(card1, card2))
\dontshow{\}) # examplesIf}
\dontshow{if (require("ggplot2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(ggplot2)
library(rtables)

card1 <- ReportCard$new()

card1$append_text("Header 2 text", "header2")
card1$append_text("A paragraph of default text")
card1$append_plot(
 ggplot(iris, aes(x = Petal.Length)) + geom_histogram()
)

card2 <- ReportCard$new()

card2$append_text("Header 2 text", "header2")
card2$append_text("A paragraph of default text")
lyt <- analyze(split_rows_by(basic_table(), "Day"), "Ozone", afun = mean)
table_res2 <- build_table(lyt, airquality)
card2$append_table(table_res2)

reporter <- Reporter$new()
reporter$append_cards(list(card1, card2))
reporter$get_cards()
\dontshow{\}) # examplesIf}
\dontshow{if (require("ggplot2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(ggplot2)
library(rtables)

card1 <- ReportCard$new()

card1$append_text("Header 2 text", "header2")
card1$append_text("A paragraph of default text")
card1$append_plot(
 ggplot(iris, aes(x = Petal.Length)) + geom_histogram()
)

card2 <- ReportCard$new()

card2$append_text("Header 2 text", "header2")
card2$append_text("A paragraph of default text")
lyt <- analyze(split_rows_by(basic_table(), "Day"), "Ozone", afun = mean)
table_res2 <- build_table(lyt, airquality)
card2$append_table(table_res2)

reporter <- Reporter$new()
reporter$append_cards(list(card1, card2))
reporter$get_blocks()
\dontshow{\}) # examplesIf}

## ------------------------------------------------
## Method `Reporter$new`
## ------------------------------------------------

reporter <- Reporter$new()


## ------------------------------------------------
## Method `Reporter$get_reactive_add_card`
## ------------------------------------------------

library(shiny)

isolate(Reporter$new()$get_reactive_add_card())

## ------------------------------------------------
## Method `Reporter$get_metadata`
## ------------------------------------------------

reporter <- Reporter$new()$append_metadata(list(sth = "sth"))
reporter$get_metadata()


## ------------------------------------------------
## Method `Reporter$append_metadata`
## ------------------------------------------------

reporter <- Reporter$new()$append_metadata(list(sth = "sth"))
reporter$get_metadata()


## ------------------------------------------------
## Method `Reporter$from_reporter`
## ------------------------------------------------

reporter <- Reporter$new()
reporter$from_reporter(reporter)

## ------------------------------------------------
## Method `Reporter$to_list`
## ------------------------------------------------

reporter <- Reporter$new()
tmp_dir <- file.path(tempdir(), "testdir")
dir.create(tmp_dir)
reporter$to_list(tmp_dir)

## ------------------------------------------------
## Method `Reporter$from_list`
## ------------------------------------------------

reporter <- Reporter$new()
tmp_dir <- file.path(tempdir(), "testdir")
unlink(tmp_dir, recursive = TRUE)
dir.create(tmp_dir)
reporter$from_list(reporter$to_list(tmp_dir), tmp_dir)

## ------------------------------------------------
## Method `Reporter$to_jsondir`
## ------------------------------------------------

reporter <- Reporter$new()
tmp_dir <- file.path(tempdir(), "jsondir")
dir.create(tmp_dir)
reporter$to_jsondir(tmp_dir)

## ------------------------------------------------
## Method `Reporter$from_jsondir`
## ------------------------------------------------

reporter <- Reporter$new()
tmp_dir <- file.path(tempdir(), "jsondir")
dir.create(tmp_dir)
unlink(list.files(tmp_dir, recursive = TRUE))
reporter$to_jsondir(tmp_dir)
reporter$from_jsondir(tmp_dir)
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Reporter-new}{\code{Reporter$new()}}
\item \href{#method-Reporter-append_cards}{\code{Reporter$append_cards()}}
\item \href{#method-Reporter-get_cards}{\code{Reporter$get_cards()}}
\item \href{#method-Reporter-get_blocks}{\code{Reporter$get_blocks()}}
\item \href{#method-Reporter-reset}{\code{Reporter$reset()}}
\item \href{#method-Reporter-remove_cards}{\code{Reporter$remove_cards()}}
\item \href{#method-Reporter-reorder_cards}{\code{Reporter$reorder_cards()}}
\item \href{#method-Reporter-get_reactive_add_card}{\code{Reporter$get_reactive_add_card()}}
\item \href{#method-Reporter-get_metadata}{\code{Reporter$get_metadata()}}
\item \href{#method-Reporter-append_metadata}{\code{Reporter$append_metadata()}}
\item \href{#method-Reporter-from_reporter}{\code{Reporter$from_reporter()}}
\item \href{#method-Reporter-to_list}{\code{Reporter$to_list()}}
\item \href{#method-Reporter-from_list}{\code{Reporter$from_list()}}
\item \href{#method-Reporter-to_jsondir}{\code{Reporter$to_jsondir()}}
\item \href{#method-Reporter-from_jsondir}{\code{Reporter$from_jsondir()}}
\item \href{#method-Reporter-set_id}{\code{Reporter$set_id()}}
\item \href{#method-Reporter-get_id}{\code{Reporter$get_id()}}
\item \href{#method-Reporter-clone}{\code{Reporter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-new"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{Reporter} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Object of class \code{Reporter}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{reporter <- Reporter$new()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-append_cards"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-append_cards}{}}}
\subsection{Method \code{append_cards()}}{
Append one or more \code{ReportCard} objects to the \code{Reporter}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$append_cards(cards)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cards}}{(\code{ReportCard}) or a list of such objects}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-get_cards"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-get_cards}{}}}
\subsection{Method \code{get_cards()}}{
Retrieves all \code{ReportCard} objects contained in the \code{Reporter}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$get_cards()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A (\code{list}) of \code{\link{ReportCard}} objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-get_blocks"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-get_blocks}{}}}
\subsection{Method \code{get_blocks()}}{
Compiles and returns all content blocks from the \code{\link{ReportCard}} in the \code{Reporter}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$get_blocks(sep = NewpageBlock$new())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sep}}{An optional separator to insert between each content block.
Default is a \code{NewpageBlock$new()}object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{list()} list of \code{TableBlock}, \code{TextBlock}, \code{PictureBlock} and \code{NewpageBlock}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-reset"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-reset}{}}}
\subsection{Method \code{reset()}}{
Resets the \code{Reporter}, removing all \code{\link{ReportCard}} objects and metadata.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$reset()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{self}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-remove_cards"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-remove_cards}{}}}
\subsection{Method \code{remove_cards()}}{
Removes specific \code{ReportCard} objects from the \code{Reporter} by their indices.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$remove_cards(ids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{(\code{character}) the ids of the cards to be removed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-reorder_cards"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-reorder_cards}{}}}
\subsection{Method \code{reorder_cards()}}{
Reorders \code{ReportCard} or \code{ReportDocument} objects in \code{Reporter}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$reorder_cards(new_order)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_order}}{\code{character} vector with card ids in the desired order.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-get_reactive_add_card"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-get_reactive_add_card}{}}}
\subsection{Method \code{get_reactive_add_card()}}{
Gets the current value of the reactive variable for adding cards.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$get_reactive_add_card()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{reactive_add_card} current \code{numeric} value of the reactive variable.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(shiny)

isolate(Reporter$new()$get_reactive_add_card())
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-get_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-get_metadata}{}}}
\subsection{Method \code{get_metadata()}}{
Get the metadata associated with this \code{Reporter}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$get_metadata()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{named list} of metadata to be appended.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{reporter <- Reporter$new()$append_metadata(list(sth = "sth"))
reporter$get_metadata()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-append_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-append_metadata}{}}}
\subsection{Method \code{append_metadata()}}{
Appends metadata to this \code{Reporter}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$append_metadata(meta)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{meta}}{(\verb{named list}) of metadata to be appended.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{reporter <- Reporter$new()$append_metadata(list(sth = "sth"))
reporter$get_metadata()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-from_reporter"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-from_reporter}{}}}
\subsection{Method \code{from_reporter()}}{
Reinitializes a \code{Reporter} instance by copying the report cards and metadata from another \code{Reporter}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$from_reporter(reporter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reporter}}{(\code{Reporter}) instance to copy from.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{reporter <- Reporter$new()
reporter$from_reporter(reporter)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-to_list"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-to_list}{}}}
\subsection{Method \code{to_list()}}{
Convert a \code{Reporter} to a list and transfer any associated files to specified directory.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$to_list(output_dir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{output_dir}}{(\code{character(1)}) a path to the directory where files will be copied.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\verb{named list} representing the \code{Reporter} instance, including version information,
metadata, and report cards.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{reporter <- Reporter$new()
tmp_dir <- file.path(tempdir(), "testdir")
dir.create(tmp_dir)
reporter$to_list(tmp_dir)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-from_list"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-from_list}{}}}
\subsection{Method \code{from_list()}}{
Reinitializes a \code{Reporter} from a list representation and associated files in a specified directory.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$from_list(rlist, output_dir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rlist}}{(\verb{named list}) representing a \code{Reporter} instance.}

\item{\code{output_dir}}{(\code{character(1)}) a path to the directory from which files will be copied.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{reporter <- Reporter$new()
tmp_dir <- file.path(tempdir(), "testdir")
unlink(tmp_dir, recursive = TRUE)
dir.create(tmp_dir)
reporter$from_list(reporter$to_list(tmp_dir), tmp_dir)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-to_jsondir"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-to_jsondir}{}}}
\subsection{Method \code{to_jsondir()}}{
Serializes the \code{Reporter} to a \code{JSON} file and copies any associated files to a specified directory.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$to_jsondir(output_dir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{output_dir}}{(\code{character(1)}) a path to the directory where files will be copied, \code{JSON} and statics.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{output_dir} argument.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{reporter <- Reporter$new()
tmp_dir <- file.path(tempdir(), "jsondir")
dir.create(tmp_dir)
reporter$to_jsondir(tmp_dir)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-from_jsondir"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-from_jsondir}{}}}
\subsection{Method \code{from_jsondir()}}{
Reinitializes a \code{Reporter} from a \code{JSON } file and files in a specified directory.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$from_jsondir(output_dir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{output_dir}}{(\code{character(1)}) a path to the directory with files, \code{JSON} and statics.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{reporter <- Reporter$new()
tmp_dir <- file.path(tempdir(), "jsondir")
dir.create(tmp_dir)
unlink(list.files(tmp_dir, recursive = TRUE))
reporter$to_jsondir(tmp_dir)
reporter$from_jsondir(tmp_dir)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-set_id"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-set_id}{}}}
\subsection{Method \code{set_id()}}{
Set the \code{Reporter} id
Optionally add id to a \code{Reporter} which will be compared when it is rebuilt from a list.
The id is added to the downloaded file name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$set_id(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)}) a Report id.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-get_id"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-get_id}{}}}
\subsection{Method \code{get_id()}}{
Get the \code{Reporter} id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$get_id()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{character(1)} the \code{Reporter} id.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
