% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcv.R
\name{chooseFacNumber_ratio}
\alias{chooseFacNumber_ratio}
\title{Estimating the Number of Factor by Eigenvalue Ratio of Natural Parameter Matrix in Generalized Factor Model.}
\usage{
chooseFacNumber_ratio(
  XList,
  types,
  q_set = 1:5,
  select_method = c("SVR", "IC"),
  offset = FALSE,
  dc_eps = 1e-04,
  maxIter = 30,
  verbose = FALSE,
  parallelList = NULL
)
}
\arguments{
\item{XList}{A list that containing an n by p matrix, where n is the number of samples, p is the number of features.}

\item{types}{The type of data. In Poisson factor models, the type is "poisson".}

\item{q_set}{The maximum number of factors for conducting ratio methods. Default as 5.}

\item{select_method}{The methods to conduct GFM. Default as AM.}

\item{offset}{Default as FALSE.}

\item{dc_eps}{The tolerance for convergence. Default as 1e-4.}

\item{maxIter}{The maximum iteration times. Defualt as 30.}

\item{verbose}{Default as FALSE}

\item{parallelList}{Whether to use parallel. Default as NULL.}
}
\value{
The number of factors estimated by ratio methods.
}
\description{
Estimating the Number of Factor by Eigenvalue Ratio of Natural Parameter Matrix in Generalized Factor Model.
}
