% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbr_misc.R
\name{tbr_misc}
\alias{tbr_misc}
\title{Use Generic Functions with Time Windows}
\usage{
tbr_misc(.tbl, x, tcolumn, unit = "years", n, na.pad = TRUE, func, ...)
}
\arguments{
\item{.tbl}{a data frame with at least two variables; time column formatted
as date, date/time and value column.}

\item{x}{column containing the values the function is applied to.}

\item{tcolumn}{formatted time column.}

\item{unit}{character, one of "years", "months", "weeks", "days", "hours", "minutes", "seconds"}

\item{n}{numeric, describing the length of the time window.}

\item{na.pad}{logical. If `na.pad = TRUE` incomplete windows (duration of the window < `n`) return `NA`. Defaults to `TRUE`}

\item{func}{specified function}

\item{...}{optional additional arguments passed to function \code{func}}
}
\value{
tibble
}
\description{
Use Generic Functions with Time Windows
}
\examples{
tbr_misc(Dissolved_Oxygen, x = Average_DO, tcolumn = Date, unit = "years", 
n = 5, na.pad = FALSE, func = mean)
}
