% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tree.R
\name{get_tree}
\alias{get_tree}
\title{get_tree}
\usage{
get_tree(
  filename,
  extant = TRUE,
  recname = NULL,
  ultrametric = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{filename}{path where files or qs2/rds was exported, reconstruct object of class tabs or recvect object}

\item{extant}{boolean, only for currently existing shapes (TRUE) or all shapes (FALSE)}

\item{recname}{recname, default NULL will create a tree for every merged polygon}

\item{ultrametric}{boolean, if TRUE, all the tips (leaves) are the same distance from the root}

\item{verbose}{boolean, print messages}
}
\value{
list of dendrogram objects
}
\description{
get the tree based on a tabs object or recvect object
}
\examples{
\dontrun{
# load data samples
sporades <- sporades()
topo <- sporades$topo
labs <- sporades$labs
curve <- sporades$curve


# change duplicated names 
duplicates <- labs[labs$name == 'UNKNOWN',]$name
labs[labs$name == 'UNKNOWN',]$name <- paste0(duplicates,' ',toupper(letters[1:length(duplicates)]))

# reconstruct
rec <- reconstruct(topo=topo,
                   region=labs,
                   curve=curve,
                   reclabs='name'
                   )

# present day shapes only
trees_e <- get_tree(rec,
                    extant=TRUE,
                    ultrametric=FALSE)
trees_e_u <- get_tree(rec,
                      extant=TRUE,
                      ultrametric=TRUE)
                      
par(mar=c(4,4,2,8),mfrow=c(1,2), oma = c(0, 0, 4, 0))
plot(trees_e[[2]], horiz = TRUE, 
     main = "Observed tree", xlab = "Years BP")
plot(trees_e_u[[2]], horiz = TRUE, 
     main = "Ultrametric tree", xlab = "Years BP")                  
mtext("Connectivity change over time", outer = TRUE, cex = 1.5, line = 1) 
mtext("present-day islands", outer = TRUE, cex = 1, line = -0.2) 
            
# present and past shapes               
trees_a <- get_tree(rec,
                    extant=FALSE,
                    ultrametric=FALSE)
trees_a_u <- get_tree(rec,
                      extant=FALSE,
                      ultrametric=TRUE)
         
par(mar=c(4,0,2,8),mfrow=c(1,2), oma = c(0, 0, 4, 0))
plot(trees_a[[2]], 
     horiz = TRUE, 
     main = "Observed tree", 
     xlab = "Years BP")
plot(trees_a_u[[2]], 
     horiz = TRUE, 
     main = "Ultrametric tree", 
     xlab = "Years BP")
mtext("Connectivity change over time", outer = TRUE, cex = 1.5, line = 1) 
mtext("present and past islands", outer = TRUE, cex = 1, line = -0.2) 
                     
# select specific shape for which the connectivity change is plotted
tree <- get_tree(rec,
                 recname=rec$recvect$AP0000000$recname[6],
                 extant=FALSE)
par(mar=c(4,0,2,8),mfrow=c(1,1), oma = c(0, 0, 0, 0))
plot(tree$`Nisí Peristéra`, 
     horiz = TRUE, 
     main = "Observed tree", 
     xlab = "Years BP")
}
}
\author{
Johannes De Groeve
}
