% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask-type.R
\name{sparsemax}
\alias{sparsemax}
\alias{sparsemax15}
\title{Sparsemax}
\usage{
sparsemax(dim = -1L)

sparsemax15(dim = -1L, k = NULL)
}
\arguments{
\item{dim}{The dimension along which to apply sparsemax.}

\item{k}{The number of largest elements to partial-sort input over. For optimal
performance, \code{k} should be slightly bigger than the expected number of
non-zeros in the solution. If the solution is more than k-sparse,
this function is recursively called with a 2*k schedule. If \code{NULL}, full
sorting is performed from the beginning.}
}
\value{
The projection result, such that \eqn{\sum_{dim} P = 1 \forall dim} elementwise.
}
\description{
Normalizing sparse transform (a la softmax).
}
\details{
Solves the projection:

\eqn{\min_P ||input - P||_2 \text{ s.t. } P \geq0, \sum(P) ==1}
}
\examples{
\dontshow{if (torch::torch_is_installed()) withAutoprint(\{ # examplesIf}
\dontrun{
input <- torch::torch_randn(10, 5, requires_grad = TRUE)
# create a top3 alpha=1.5 sparsemax on last input dimension
nn_sparsemax <- sparsemax15(dim=1, k=3)
result <- nn_sparsemax(input)
print(result)
}
\dontshow{\}) # examplesIf}
}
