% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{node_to_df}
\alias{node_to_df}
\title{Turn a Node object into predictor and outcome.}
\usage{
node_to_df(x, drop_last_level = TRUE)
}
\arguments{
\item{x}{Node object}

\item{drop_last_level}{TRUE unused}
}
\value{
a named list of x and y, being respectively the predictor data-frame and the outcomes data-frame,
as expected inputs for \code{hardhat::mold()} function.
}
\description{
Turn a Node object into predictor and outcome.
}
\examples{
\dontshow{if ((require("data.tree") || require("dplyr"))) withAutoprint(\{ # examplesIf}
library(dplyr)
library(data.tree)
data(starwars)
starwars_tree <- starwars \%>\%
  mutate(pathString = paste("tree", species, homeworld, `name`, sep = "/")) \%>\%
  as.Node()
node_to_df(starwars_tree)$x \%>\% head()
node_to_df(starwars_tree)$y \%>\% head()
\dontshow{\}) # examplesIf}
}
