% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{rotate_las_z}
\alias{rotate_las_z}
\title{Rotate `LAS` object about the `Z` axis}
\usage{
rotate_las_z(las, angle)
}
\arguments{
\item{las}{`LAS` object from `lidR` package representing
individually segmented tree}

\item{angle}{numeric - in degrees, rotation angle about Z axis.}
}
\value{
A `LAS` object rotated about the Z axis.
}
\description{
Rotate `LAS` object about the `Z` axis for specified angle.
}
\examples{
library(lidR)
las = readLAS(system.file("extdata", "tree_0744.laz", package="tReeTraits"))
las_rotated = rotate_las_z(las, 90)
\donttest{
plot(las)
plot(las_rotated)
}
}
