% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_qsm.R
\name{get_stem_sweep}
\alias{get_stem_sweep}
\title{Calculate tree sweep from straight line from QMS}
\usage{
get_stem_sweep(qsm, terminus_diam_cm = 4, plot = TRUE)
}
\arguments{
\item{qsm}{QSM loaded using `[load_qsm()]`.}

\item{terminus_diam_cm}{numeric -- the trunk diameter at which is no longer
considered trunk}

\item{plot}{boolean -- indicates whether graph of sweep should be plotted.}
}
\value{
A data frame with columns:
\describe{
  \item{Height}{Height (m) of each trunk segment midpoint.}
  \item{sweep}{Perpendicular deviation (m) from the idealized straight stem line.}
}
}
\description{
This function calculates tree sweep from a QSM. Starting with an idealized
vector of a straight tree (straight line from top to bottom QSM segment)
the function caclucates devations of points along the trunk from the
idealized vector. It resturns sweep from each QSM segment so that
summary statistics can be computed by the user. See also `get_stem_deflection()`
}
\examples{
qsm_file = system.file("extdata", "tree_0744_qsm.txt", package='tReeTraits')
qsm = load_qsm(qsm_file)
print(get_center_of_mass(qsm))
print(get_com_offset(qsm))
}
