% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_point_cloud.R
\name{get_crown_volume_voxel}
\alias{get_crown_volume_voxel}
\title{Estimate crown volume by voxelization}
\usage{
get_crown_volume_voxel(las, resolution = 0.1)
}
\arguments{
\item{las}{`LAS` object from `lidR` package representing
a tree. Crowns must be segmented using [segment_crown()].}

\item{resolution}{numeric - resolution of voxelization}
}
\value{
A named numeric vector with element `crown_volume_vox` (m^3).
}
\description{
This function volume of a `LAS` object by thinning to a resolution specified
by `resolution`, and estimating volume using the equation
\deqn{Volume_{crown} = N_{occupied voxel} * Volume_{voxel}}
}
\examples{
las = lidR::readLAS(system.file("extdata", "tree_0744.laz", package="tReeTraits"))
las = clean_las(las)
cbh = get_crown_base(las, threshold=0.25, sustain=2)
las = segment_crown(las, cbh)
get_crown_volume_voxel(las)
get_crown_volume_alpha(las)
sf::st_area(convex_hull_2D(las)) #profile area, convex hull
sf::st_area(voxel_hull_2D(las)) #profile area, voxel hull
get_lacunarity(las)
}
