% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimating-equations.R
\name{estim_eq_test}
\alias{estim_eq_test}
\alias{print.estim_eq_test}
\alias{summary.estim_eq_test}
\alias{tidy.estim_eq_test}
\alias{glance.estim_eq_test}
\title{Estimating Equations Test for Informative Sampling (Linear Case)}
\usage{
estim_eq_test(
  model,
  coef_subset = NULL,
  q_method = c("linear", "log"),
  stabilize = TRUE,
  na.action = stats::na.omit
)

\method{print}{estim_eq_test}(x, ...)

\method{summary}{estim_eq_test}(object, ...)

\method{tidy}{estim_eq_test}(x, ...)

\method{glance}{estim_eq_test}(x, ...)
}
\arguments{
\item{model}{An object of class \code{svyglm} with \code{family = gaussian(identity)}.}

\item{coef_subset}{Optional character vector of coefficient names to include in the test.
Defaults to all coefficients in the model matrix.}

\item{q_method}{Method for estimating \eqn{E_s(w \mid x)}:
\code{"linear"} (default, OLS regression of w on X) or
\code{"log"} (regress log(w) on X, then exponentiate).}

\item{stabilize}{Logical; if \code{TRUE} (default) clips extreme q values.}

\item{na.action}{Function to handle missing data.}

\item{x}{An object of class estim_eq_test}

\item{...}{Additional arguments passed to methods}

\item{object}{An object of class estim_eq_test}
}
\value{
An object of class \code{"estim_eq_test"} containing:
  \item{statistic}{Hotelling F statistic}
  \item{p.value}{p-value under F distribution}
  \item{df1}{Numerator df (# tested coefficients)}
  \item{df2}{Denominator df (n - p)}
  \item{Rbar}{Mean estimating-equation contrast vector}
  \item{S}{Sample covariance of R}
  \item{terms}{Names of tested coefficients}
  \item{n}{Sample size}
  \item{call}{Matched call}
  \item{method}{Description string}
}
\description{
Implements the Pfeffermann-Sverchkov estimating equations test for
informativeness of survey weights in the linear regression case
(Gaussian with identity link). The test compares unweighted estimating
equations to adjusted-weight equations using \eqn{q_i = w_i / E_s(w_i \mid x_i)}.
}
\details{
For linear regression, the per-observation score is
\eqn{u_i = x_i (y_i - x_i^\top \hat\beta_{\text{unw}})} at the unweighted OLS estimate.
The test statistic is based on \eqn{R_i = (1 - q_i) u_i}, where
\eqn{q_i = w_i / E_s(w_i \mid x_i)}. The Hotelling F statistic is
\eqn{F = \frac{n-p}{p} \bar R^\top S^{-1} \bar R}, with df1 = p, df2 = n - p.
}
\examples{
# Load in survey package (required) and load in example data
library(survey)
data("svytestCE", package = "svytest")

# Create a survey design and fit a weighted regression model
des <- svydesign(ids = ~1, weights = ~FINLWT21, data = svytestCE)
fit <- svyglm(TOTEXPCQ ~ ROOMSQ + BATHRMQ + BEDROOMQ + FAM_SIZE + AGE, design = des)

# Run estimating equations diagnostic test; reports F statistic, df's, and p-value
results <- estim_eq_test(fit, q_method = "linear")
print(results)

}
\references{
Pfeffermann, D., & Sverchkov, M. Y. (2003).
Fitting generalized linear models under informative sampling.
In R. L. Chambers & C. J. Skinner (Eds.), *Analysis of Survey Data* (Ch. 12). Wiley.
}
\seealso{
\code{\link{diff_in_coef_test}}, \code{\link{wa_test}}, \code{\link{perm_test}}
}
