% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superbShiny.R
\name{superbShiny}
\alias{superbShiny}
\title{User Interface to get summary plot of any statistics with adjusted error bars.}
\usage{
superbShiny(graphicDirectives = NULL)
}
\arguments{
\item{graphicDirectives}{(optional) used to set graphic directives from the command line.
This is useful for in-class demonstrations where the \code{ylim()} range should be set before
reaching the last step of the interface.}
}
\value{
A plot that can be cut-and-paste.
}
\description{
The function \code{suberbShiny()} provides a simple user interface
to plot standard error or confidence interval for various descriptive
statistics under various designs, population size and purposes,
according to the \code{suberb} framework. See \insertCite{cgh21}{superb} for more.
Also see this \href{https://www.youtube.com/watch?v=rw_6ll5nVus/}{video}
from \insertCite{w21}{superb} for a demo using
the shinyapps.io installation accessible at
\href{https://dcousin3.shinyapps.io/superbshiny/}{dcousin3.shinyapps.io/superbshiny}
Limitations: it is neither possible to use custom-made statistics with the
graphical user interface, nor is it possible to request an adjustment for cluster-
randomized sampling. These options are available with \code{superb()}.
}
\examples{
# Launch the user interface: 
\donttest{
if (interactive())
   superbShiny() 
}

# Example with two graphic directives given 
\donttest{
if (interactive())
   superbShiny( "ylim(65,135)+theme_bw()" )
}


}
\references{
\insertAllCited
}
