\name{plot_sign_grammar}
\alias{plot_sign_grammar}
\title{Stacked Bar Chart of Grammatical Type Frequencies}
\description{
Creates a stacked bar chart from the output of \code{\link{sign_grammar}} or
\code{\link{grammar_probs}}. Each bar represents one sign position in the
sentence. The colours indicate the relative frequency or posterior
probability of each individual grammatical type.
}
\usage{
plot_sign_grammar(sg,
                  output_file = NULL,
                  width       = 10,
                  height      = 5,
                  sign_names  = FALSE,
                  font_family = NULL)
}
\arguments{
  \item{sg}{A data frame as returned by \code{\link{sign_grammar}} (with
    column \code{n}) or \code{\link{grammar_probs}} (with column
    \code{prob}).}

  \item{output_file}{Character. File path for saving the plot (PNG or JPG).
    If \code{NULL} (default), the plot is displayed on the current device.}

  \item{width}{Numeric. Plot width in inches. Default: 10.}

  \item{height}{Numeric. Plot height in inches. Default: 5.}

  \item{sign_names}{Logical. Whether sign names or cuneiform characters should be used as labels of the x-axis. Default: FALSE.}

  \item{font_family}{Character. Font family for cuneiform x-axis labels.
    If \code{NULL} (default), a cuneiform-capable font is detected
    automatically.}
}
\details{
When the input comes from \code{sign_grammar()} (column \code{n}),
absolute frequencies are converted to percentages so that bars sum to
100\%. When the input comes from \code{grammar_probs()} (column
\code{prob}), posterior probabilities are used directly.

Colours are assigned per grammatical type, grouped by class:
\itemize{
  \item Red shades: Verbs (\code{V}) and operators returning verbs
  \item Blue shades: Operators returning attributes \code{A}
  \item Orange: Adjectives and other signs with grammatical type (\code{Sx->S})
  \item Green: Nouns

  \item Grey/other shades: All other types
}
}
\value{
Invisibly returns the \pkg{ggplot2} plot object.
}
\examples{
dic   <- read_dictionary()
sg    <- sign_grammar("a-ma-ru ba-ur3 ra", dic)

# Plot raw frequencies
file <- file.path(tempdir(), "test.png")
plot_sign_grammar(sg, file)

# Plot probabilities
prior <- prior_probs(dic, sentence_prob = 0.25)
gp    <- grammar_probs(sg, prior, dic, alpha0 = 1)
file  <- file.path(tempdir(), "test2.png")
plot_sign_grammar(gp, file)
}
\seealso{
\code{\link{sign_grammar}} for generating raw frequency data,
\code{\link{grammar_probs}} for Bayesian posterior probabilities,
\code{\link{prior_probs}} for computing the prior.
}
\keyword{hplot}
