% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extras.R
\name{extras}
\alias{extras}
\title{Add standard styling and formatting to gtsummary tables}
\usage{
extras(
  tbl,
  pval = TRUE,
  overall = TRUE,
  last = FALSE,
  header = "",
  symbol = "---",
  .args = NULL,
  .add_p_args = NULL
)
}
\arguments{
\item{tbl}{A gtsummary table object (e.g., from
\code{tbl_summary()}, \code{tbl_regression()})}

\item{pval}{Logical indicating whether to add p-values. Default is \code{TRUE}.
When \code{TRUE}, uses gtsummary's default statistical tests (Kruskal-Wallis for
continuous variables with 3+ groups, chi-square for categorical variables).}

\item{overall}{Logical indicating whether to add overall column}

\item{last}{Logical indicating if Overall column
should be last. Aligns with default from
\code{gtsummary::add_overall()}.}

\item{header}{Character string for the label column
header. Default is \code{""} (blank). Use \code{"Characteristic"}
or any custom text.}

\item{symbol}{Character string for missing value
replacement in \code{clean_table()}. Default is \code{"---"}.
Passed directly to \code{clean_table(symbol = ...)}.}

\item{.args}{Optional list of arguments to use
instead of individual parameters.
When provided, overrides \code{pval}, \code{overall}, \code{last},
\code{header}, and \code{symbol} arguments.}

\item{.add_p_args}{Optional named list of arguments
to pass to \code{gtsummary::add_p()}. Allows customization
of statistical tests and p-value formatting.
User-provided arguments override the default arguments
(\code{pvalue_fun} and \code{test.args}).
See \code{gtsummary::add_p()} documentation for available arguments.}
}
\value{
A gtsummary table object with standard formatting applied
}
\description{
Applies a consistent set of formatting
options to gtsummary tables including overall column,
bold labels, clean headers, and optional p-values.
Wraps the common workflow of adding multiple formatting
functions into one call. Always succeeds by applying
what works and warning about the rest.
}
\details{
The function applies the following modifications (in order):
\enumerate{
\item Bolds variable labels for emphasis (all table types)
\item Removes the "Characteristic" header label (all table types)
\item Adds an "Overall" column (only stratified summary tables)
\item Optionally adds p-values with bold significance (only stratified
summary tables)
\item Applies automatic labels if options are set (see Options section)
\item Applies \code{clean_table()} styling (all table types)
}

The function automatically detects whether the input
table is stratified (has a \code{by} argument) and what
type of table it is (tbl_summary, tbl_regression,
tbl_strata, etc.).

For tables that don't support overall columns or
p-values (non-stratified tables, regression tables,
or stacked tables), the function warns and applies
only basic formatting (bold_labels and modify_header).

For merged tables (\code{tbl_merge}), call \code{extras()} on each
sub-table before merging. All formatting carries through.

If any individual step fails (e.g., due to unexpected
table structure), the function warns and continues
without that feature.
}
\section{Options}{

Set \code{options(sumExtras.auto_labels = TRUE)} for automatic labeling.
See \code{vignette("options")} for details.
}

\section{Pipeline Ordering}{

Call \code{extras()} before \code{add_variable_group_header()} and
\code{add_group_colors()} last. See \code{vignette("sumExtras-intro")}.
}

\section{Table Type Support}{

Full features (overall, p-values, bold p-values) require a stratified
\code{tbl_summary} or \code{tbl_svysummary}. Regression tables get bold labels,
bold model p-values, header cleaning, and \code{clean_table()}. Stacked
(\code{tbl_strata}) and merged (\code{tbl_merge}) tables get bold labels, header
cleaning, and \code{clean_table()}. Warnings only fire when the user
explicitly requests unsupported features (e.g., \code{overall = TRUE} on a
non-stratified table).
}

\examples{
\donttest{
# With p-values (default)
gtsummary::trial |>
  gtsummary::tbl_summary(by = trt) |>
  extras()

# Using .args list
extra_args <- list(pval = TRUE, overall = TRUE, last = FALSE)
gtsummary::trial |>
  gtsummary::tbl_summary(by = trt) |>
  extras(.args = extra_args)

# Without p-values
gtsummary::trial |>
  gtsummary::tbl_summary(by = trt) |>
  extras(pval = FALSE)

# Custom header text
gtsummary::trial |>
  gtsummary::tbl_summary(by = trt) |>
  extras(header = "Variable")

# Customize add_p() behavior
gtsummary::trial |>
  gtsummary::tbl_summary(by = trt) |>
  extras(.add_p_args = list(
    test = list(age ~ "t.test", marker ~ "t.test"),
    pvalue_fun = ~ gtsummary::style_pvalue(.x, digits = 2)
  ))
}

}
\seealso{
\itemize{
\item \code{gtsummary::add_overall()} for adding overall columns
\item \code{gtsummary::add_p()} for adding p-values
\item \code{clean_table()} for additional table styling
}
}
