## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

options(gtsummary.print_engine = "gt")

## ----setup--------------------------------------------------------------------
# library(sumExtras)
# library(gtsummary)
# library(dplyr)
# library(gt)
# 
# use_jama_theme()

## ----setup2-------------------------------------------------------------------
library(sumExtras)
library(gtsummary)
library(dplyr)
library(gt)

use_jama_theme()

## -----------------------------------------------------------------------------
trial |>
  select(age, marker, grade, stage, response, trt) |>
  tbl_summary(by = trt) |>
  extras() |>
  add_variable_group_header(
    header = "Demographics",
    variables = age
  ) |>
  add_variable_group_header(
    header = "Clinical Measures",
    variables = marker:response
  )

## ----without-styling, eval=FALSE----------------------------------------------
# trial |>
#   select(age, marker, grade, stage, trt) |>
#   tbl_summary(by = trt) |>
#   extras() |>
#   add_variable_group_header(
#     header = "Patient Variables",
#     variables = age:stage
#   )

## ----with-styling, eval=FALSE-------------------------------------------------
# trial |>
#   select(age, marker, grade, stage, trt) |>
#   tbl_summary(by = trt) |>
#   extras() |>
#   add_variable_group_header(
#     header = "Patient Variables",
#     variables = age:stage
#   ) |>
#   add_group_styling()

## ----build-styling, echo=FALSE------------------------------------------------
table_without <- trial |>
  select(age, marker, grade, stage, trt) |>
  tbl_summary(by = trt) |>
  extras() |>
  add_variable_group_header(
    header = "Patient Variables",
    variables = age:stage
  )

table_with <- trial |>
  select(age, marker, grade, stage, trt) |>
  tbl_summary(by = trt) |>
  extras() |>
  add_variable_group_header(
    header = "Patient Variables",
    variables = age:stage
  ) |>
  add_group_styling()

## ----render-without, echo=FALSE-----------------------------------------------
table_without

## ----render-with, echo=FALSE--------------------------------------------------
table_with

## -----------------------------------------------------------------------------
# Bold only
trial |>
  select(age, marker, grade, stage, trt) |>
  tbl_summary(by = trt) |>
  extras() |>
  add_variable_group_header(
    header = "Patient Characteristics",
    variables = age:stage
  ) |>
  add_group_styling(format = "bold")

## -----------------------------------------------------------------------------
trial |>
  select(age, marker, grade, stage, response, trt) |>
  tbl_summary(by = trt) |>
  extras() |>
  add_variable_group_header(
    header = "Demographics",
    variables = age
  ) |>
  add_variable_group_header(
    header = "Clinical Measures",
    variables = marker:response
  ) |>
  add_group_styling() |>
  add_group_colors(color = "#E3F2FD")

## -----------------------------------------------------------------------------
trial |>
  select(age, marker, grade, stage, response, trt) |>
  tbl_summary(by = trt) |>
  extras() |>
  add_variable_group_header(
    header = "Demographics",
    variables = age
  ) |>
  add_variable_group_header(
    header = "Clinical Measures",
    variables = marker:response
  ) |>
  add_group_styling() |>
  add_group_colors(color = c("#E3F2FD", "#FFF9E6"))

## -----------------------------------------------------------------------------
my_table <- trial |>
  select(age, marker, grade, stage, trt) |>
  tbl_summary(by = trt) |>
  extras() |>
  add_variable_group_header(
    header = "Demographics",
    variables = age:marker
  ) |>
  add_variable_group_header(
    header = "Disease",
    variables = grade:stage
  ) |>
  add_group_styling()

group_rows <- get_group_rows(my_table)

my_table |>
  as_gt() |>
  gt::tab_style(
    style = list(
      gt::cell_fill(color = "#E8E8E8"),
      gt::cell_text(weight = "bold")
    ),
    locations = gt::cells_body(rows = group_rows)
  )

## ----match-gtsummary, eval=FALSE----------------------------------------------
# trial |>
#   tbl_summary(
#     by = trt,
#     include = c(age, grade, marker)
#   ) |>
#   extras()

## ----match-gt, eval=FALSE-----------------------------------------------------
# trial |>
#   select(trt, age, grade, marker) |>
#   head(10) |>
#   gt() |>
#   theme_gt_compact()

## ----build-match, echo=FALSE--------------------------------------------------
table_gtsummary <- trial |>
  tbl_summary(
    by = trt,
    include = c(age, grade, marker)
  ) |>
  extras()

table_gt <- trial |>
  select(trt, age, grade, marker) |>
  head(10) |>
  gt() |>
  theme_gt_compact()

## ----render-match-gtsummary, echo=FALSE---------------------------------------
table_gtsummary

## ----render-match-gt, echo=FALSE----------------------------------------------
table_gt

## -----------------------------------------------------------------------------
dictionary <- tibble::tribble(
  ~variable,    ~description,
  "trt",        "Treatment Assignment",
  "age",        "Age at Baseline (years)",
  "marker",     "Biomarker Level (ng/mL)",
  "stage",      "Clinical Stage",
  "grade",      "Tumor Grade",
  "response",   "Treatment Response",
  "death",      "Patient Died"
)

trial |>
  select(trt, age, marker, grade, stage, response, death) |>
  tbl_summary(by = trt, missing = "no") |>
  add_auto_labels(dictionary = dictionary) |>
  extras() |>
  add_variable_group_header(
    header = "BASELINE CHARACTERISTICS",
    variables = age:marker
  ) |>
  add_variable_group_header(
    header = "DISEASE CHARACTERISTICS",
    variables = grade:stage
  ) |>
  add_variable_group_header(
    header = "OUTCOMES",
    variables = response:death
  ) |>
  add_group_styling() |>
  add_group_colors(color = "#E8E8E8")

