% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap.R
\name{str_wrap}
\alias{str_wrap}
\title{Wrap words into nicely formatted paragraphs}
\usage{
str_wrap(string, width = 80, indent = 0, exdent = 0, whitespace_only = TRUE)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{width}{Positive integer giving target line width (in number of
characters). A width less than or equal to 1 will put each word on its
own line.}

\item{indent, exdent}{A non-negative integer giving the indent for the
first line (\code{indent}) and all subsequent lines (\code{exdent}).}

\item{whitespace_only}{A boolean.
\itemize{
\item If \code{TRUE} (the default) wrapping will only occur at whitespace.
\item If \code{FALSE}, can break on any non-word character (e.g. \code{/}, \code{-}).
}}
}
\value{
A character vector the same length as \code{string}.
}
\description{
Wrap words into paragraphs, minimizing the "raggedness" of the lines
(i.e. the variation in length line) using the Knuth-Plass algorithm.
}
\examples{
thanks_path <- file.path(R.home("doc"), "THANKS")
thanks <- str_c(readLines(thanks_path), collapse = "\n")
thanks <- word(thanks, 1, 3, fixed("\n\n"))
cat(str_wrap(thanks), "\n")
cat(str_wrap(thanks, width = 40), "\n")
cat(str_wrap(thanks, width = 60, indent = 2), "\n")
cat(str_wrap(thanks, width = 60, exdent = 2), "\n")
cat(str_wrap(thanks, width = 0, exdent = 2), "\n")
}
\seealso{
\code{\link[stringi:stri_wrap]{stringi::stri_wrap()}} for the underlying implementation.
}
