% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdbscan.R
\name{st_dbscan}
\alias{st_dbscan}
\title{Spatio-Temporal DBSCAN}
\usage{
st_dbscan(x, y, t, eps_spatial, eps_temporal, min_pts)
}
\arguments{
\item{x}{Numeric vector of x-coordinates (spatial).}

\item{y}{Numeric vector of y-coordinates (spatial).}

\item{t}{Numeric vector of time values. \code{t} is expected to represent elapsed
time since a common origin (\emph{e.g.} c(0, 6, 10)).}

\item{eps_spatial}{Numeric. The spatial radius threshold. Points closer than
this in space may belong to the same cluster.}

\item{eps_temporal}{Numeric. The temporal threshold. Points closer than this
in time may belong to the same cluster.}

\item{min_pts}{Integer. Minimum number of points required to form a core
point (standard DBSCAN parameter).}
}
\value{
An integer vector of length \code{length(x)} with cluster assignments:
\itemize{
\item \code{-1}: noise point
\item \verb{>=1}: cluster ID
}
}
\description{
Perform \strong{ST-DBSCAN} clustering on points with spatial and temporal
coordinates. This algorithm identifies clusters of points that are close both
in space and time.
}
\details{
ST-DBSCAN extends classical DBSCAN by incorporating a temporal constraint.
Two points are considered neighbors if they are within \code{eps_spatial} in
space \strong{and} within \code{eps_temporal} in time. Clusters are expanded from core
points recursively following the DBSCAN algorithm.

This function is implemented in C++ via Rcpp for performance.
}
\examples{
data(geolife_traj)

geolife_traj$date_time <- as.POSIXct(
  paste(geolife_traj$date, geolife_traj$time),
  format = "\%Y-\%m-\%d \%H:\%M:\%S",
  tz = "GMT"
)

geolife_traj$t <- as.numeric(
  geolife_traj$date_time - min(geolife_traj$date_time)
)

st_dbscan(
  x = geolife_traj$x,
  y = geolife_traj$y,
  t = geolife_traj$t,
  eps_spatial = 3, # meters
  eps_temporal = 30, # seconds
  min_pts = 3
)

}
\references{
Birant, D., & Kut, A. (2007). ST-DBSCAN: An algorithm for clustering
spatial–temporal data. Data & Knowledge Engineering, 60(1), 208–221.
https://doi.org/10.1016/j.datak.2006.01.013
}
