% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.lc.mean.scheffe}
\alias{ci.lc.mean.scheffe}
\title{Scheffe confidence interval for a linear contrast of means in a
between-subjects design}
\usage{
ci.lc.mean.scheffe(alpha, m, sd, n, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m}{vector of estimated group means}

\item{sd}{vector of estimated group standard deviations}

\item{n}{vector of sample sizes}

\item{v}{vector of between-subjects contrast coefficients}
}
\value{
Returns a 2-row matrix. The columns are:
\itemize{
\item Estimate - estimated linear contrast
\item SE - standard error
\item t - t test statistic
\item df - degrees of freedom
\item p - two-sided Scheffe p-value
\item LL - lower limit of the Scheffe confidence interval
\item UL - upper limit of the Scheffe confidence interval
}
}
\description{
Computes a Scheffe confidence interval for a linear contrast of population
means in a between-subjects design. A Scheffe p-value is computed for the
test statistic. The Scheffe method assumes equal population variances. This
function is useful in exploratory studies where the linear contrast of
means was not planned but was suggested by the pattern of sample means. Use
the \link[statpsych]{ci.lc.mean.bs} function with a Bonferroni adjusted alpha
value to compute simultaneous confidence intervals for two or more planned
linear contrasts of means.
}
\examples{

m <- c(33.5, 37.9, 38.0, 44.1)
sd <- c(3.49, 3.84, 3.65, 4.98)
n <- c(10, 10, 10, 10)
v <- c(.5, .5, -.5, -.5)
ci.lc.mean.scheffe(.05, m, sd, n, v)

# Should return:
#  Estimate       SE       t       p        LL        UL
#     -5.35 1.275231 -4.1953 0.00228 -9.089451 -1.610549


}
\references{
\insertRef{Snedecor1980}{statpsych}
}
