testthat::context("Update Query class")

testthat::test_that("We can create an UPDATE query with the contructor", {
  where <- StmtWhere$new(ExprBinOp$new(
    ExprField$new("year"), "<",
    ExprValue$new(2010)
  ))
  set <- StmtSet$new()
  set$add_field(ExprField$new('price'), ExprValue$new(9.50))
  x <- QueryUpdate$new(StmtUpdate$new('books'), set = set)
  x$add(where)
  testthat::expect_equal(x$toString(),
                         'UPDATE books SET price = 9.5 WHERE "year" < 2010;')
})

testthat::test_that("We can create an UPDATE query using the factory", {
  where <- StmtWhere$new(ExprBinOp$new(
    ExprField$new("year"), "<",
    ExprValue$new(2010)
  ))
  set <- make_set(price = 9.50)
  x <- make_update('books', set = set, where = where)
  testthat::expect_equal(x$toString(),
                         'UPDATE books SET price = 9.5 WHERE "year" < 2010;')
})

testthat::test_that("We can update two columns", {
  where <- StmtWhere$new(ExprBinOp$new(
    ExprField$new("year"), "<",
    ExprValue$new(2010)
  ))
  set <- make_set(price = 9.50, old = TRUE)
  x <- make_update('books', set = set, where = where)
  testthat::expect_equal(x$toString(),
                         paste('UPDATE books SET price = 9.5, "old" = TRUE',
                               'WHERE "year" < 2010;'))
})
