#' DELETE FROM statement.
#'
#' @examples
#' # Simple DELETE statement:
#' StmtDelete$new('books')
#'
#' @import R6
#' @include Statement.R
#' @export
StmtDelete <- R6::R6Class("StmtDelete",
  inherit = Statement,
  public = list(

    #' @description
    #' Initializer.
    #' @param tabl A table name.
    #' @return Nothing.
    initialize = function(tabl) {
      chk::chk_string(tabl)
      private$table <- tabl
    },

    #' @description
    #' Generates the list of tokens representing this statement.
    #' @return A list of Token objects.
    getTokens = function() {
      return(list(.delete, .spc, .from, .spc,
                  TokenIdentifier$new(private$table)))
    }
  ),
  private = list(
    table = NULL
  )
)
