#' This class represents an SQL BETWEEN expression.
#'
#' Used to generate SQL expression BETWEEN / AND.
#'
#' @examples
#' # To generate "i BETWEEN 1 AND 10":
#' ExprBetween$new(ExprField$new("i"), ExprValue$new(1L), ExprValue$new(10L))
#'
#' @import R6
#' @include Expr.R
#' @export
ExprBetween <- R6::R6Class("ExprBetween",
  inherit = Expr,
  public = list(

    #' @description
    #' Initializer.
    #' @param field An ExprField instance representing the field to check.
    #' @param low An ExprValue instance representing the lower bound.
    #' @param high An ExprValue instance representing the upper bound.
    #' @return Nothing.
    initialize = function(field, low, high) {
      super$initialize()
      chk::chk_is(field, "ExprField")
      chk::chk_is(low, "ExprValue")
      chk::chk_is(high, "ExprValue")

      private$field <- field
      private$low <- low
      private$high <- high

      return(invisible(NULL))
    },

    #' @description
    #' Generates the list of tokens representing this statement.
    #' @return A list of Token objects.
    getTokens = function() {
      tokens <- private$field$getTokens()
      tokens <- c(tokens, .spc, .between, .spc, private$low$getTokens(), .spc,
                  .and, .spc, private$high$getTokens())
      return(tokens)
    }
  ),

  private = list(
    field = NULL,
    low = NULL,
    high = NULL
  )
)
