% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AICc.R
\name{AICc}
\alias{AICc}
\title{Compute AICc of fitted model objects}
\usage{
AICc(object, ..., k = 2)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}}, \code{\link[=spautor]{spautor()}}, \code{\link[=spglm]{spglm()}}, or \code{\link[=spgautor]{spgautor()}}
where \code{estmethod} is \code{"ml"} or \code{"reml"}.}

\item{...}{Optionally more fitted model objects.}

\item{k}{The penalty parameter, taken to be 2. Currently not allowed to differ
from 2 (needed for generic consistency).}
}
\value{
If just one object is provided, a numeric value with the corresponding
AICc.

If multiple objects are provided, a \code{data.frame} with rows corresponding
to the objects and columns representing the number of parameters estimated
(\code{df}) and the AICc.
}
\description{
Compute AICc for one or
several fitted model objects for which a log-likelihood
value can be obtained.
}
\details{
When comparing models fit by maximum or restricted maximum
likelihood, the smaller the AICc, the better the fit. The AICc contains
a correction to AIC for small sample sizes. The theory of
AICc requires that the log-likelihood has been maximized, and hence,
no AICc methods exist for models where \code{estmethod} is not
\code{"ml"} or \code{"reml"}. Additionally, AICc comparisons between \code{"ml"}
and \code{"reml"} models are meaningless -- comparisons should only be made
within a set of models estimated using \code{"ml"} or a set of models estimated
using \code{"reml"}. AICc comparisons for \code{"reml"} must
use the same fixed effects. To vary the covariance parameters and
fixed effects simultaneously, use \code{"ml"}.

Hoeting et al. (2006) study AIC and AICc in a spatial context, using the AIC definition
\eqn{-2loglik + 2(estparams)} and the AICc definition as
\eqn{-2loglik + 2n(estparams) / (n - estparams - 1)}, where \eqn{n} is the sample size
and \eqn{estparams} is the number of estimated parameters. For \code{"ml"}, \eqn{estparams} is
the number of estimated covariance parameters plus the number of estimated
fixed effects. For \code{"reml"}, \eqn{estparams} is the number of estimated covariance
parameters.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
AICc(spmod)
AIC(spmod)
BIC(spmod)
}
\seealso{
\code{\link[stats:AIC]{stats::AIC()}} \code{\link[stats:AIC]{stats::BIC()}}
}
