% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thinning.R
\name{thinning}
\alias{thinning}
\title{Applies thinning to pairs of coordinates}
\usage{
thinning(xy, minimum.distance = NULL)
}
\arguments{
\item{xy}{A data frame with columns named "x" and "y" representing geographic coordinates.}

\item{minimum.distance}{Numeric, minimum distance to be set between nearby points, in the same units as the coordinates of xy.}
}
\value{
A data frame with the same columns as \code{xy} with points separated by the defined minimum distance.
}
\description{
Resamples a set of points with x and y coordinates to impose a minimum distance among nearby points.
}
\details{
Generally used to remove redundant points that could produce pseudo-replication, and to limit sampling bias by disaggregating clusters of points.
}
\examples{

data(plants_xy)

y <- thinning(
  xy = plants_xy,
  minimum.distance = 10
)

if (interactive()) {
  plot(
    plants_xy[, c("x", "y")],
    col = "blue",
    pch = 15
  )

  points(
    y[, c("x", "y")],
    col = "red",
    pch = 15
  )
}

}
\seealso{
\code{\link[=thinning_til_n]{thinning_til_n()}}

Other utilities: 
\code{\link{.vif_to_df}()},
\code{\link{auc}()},
\code{\link{beowulf_cluster}()},
\code{\link{objects_size}()},
\code{\link{optimization_function}()},
\code{\link{prepare_importance_spatial}()},
\code{\link{rescale_vector}()},
\code{\link{root_mean_squared_error}()},
\code{\link{setup_parallel_execution}()},
\code{\link{standard_error}()},
\code{\link{statistical_mode}()},
\code{\link{thinning_til_n}()}
}
\concept{utilities}
