% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standard_error.R
\name{standard_error}
\alias{standard_error}
\title{Standard error of the mean of a numeric vector}
\usage{
standard_error(x)
}
\arguments{
\item{x}{A numeric vector.}
}
\value{
A numeric value.
}
\description{
Computes the standard error of the mean of a numeric vector as \code{round(sqrt(var(x)/length(x)), 3)}
}
\details{
The function removes \code{NA} values before computing the standard error, and rounds the result to 3 decimal places.
}
\examples{

standard_error(x = runif(10))

}
\seealso{
Other utilities: 
\code{\link{.vif_to_df}()},
\code{\link{auc}()},
\code{\link{beowulf_cluster}()},
\code{\link{objects_size}()},
\code{\link{optimization_function}()},
\code{\link{prepare_importance_spatial}()},
\code{\link{rescale_vector}()},
\code{\link{root_mean_squared_error}()},
\code{\link{setup_parallel_execution}()},
\code{\link{statistical_mode}()},
\code{\link{thinning}()},
\code{\link{thinning_til_n}()}
}
\concept{utilities}
