% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourcoise_refresh.R
\name{sourcoise_refresh}
\alias{sourcoise_refresh}
\title{Refresh sourcoise cache by executing sources selected}
\usage{
sourcoise_refresh(
  what = NULL,
  force_exec = TRUE,
  unfreeze = TRUE,
  quiet = FALSE,
  init_fn = getOption("sourcoise.init_fn"),
  root = getOption("sourcoise.root"),
  priotirize = TRUE,
  log = "INFO",
  .progress = TRUE
)
}
\arguments{
\item{what}{(tibble) a tibble as generated by \code{sourcoise_status()}, possibly filtered, (defaut to \code{source_status()} ). What can also be a vector of strings to filter srouces files by name.}

\item{force_exec}{(boolean) (default \code{FALSE}) if \code{TRUE} code is executed, no matter what is cached}

\item{unfreeze}{(boolean) (default \code{TRUE}) when possible, unfreeze and uncache .qmd files in a quarto project when data used by those .qmd has been refreshed}

\item{quiet}{(boolean) (default \code{FALSE}) no message if TRUE}

\item{init_fn}{(function) (default \code{NULL}) execute a function before sourcing to allow initialization}

\item{root}{(default \code{NULL}) force root to be set, instead of letting the function finding the root, for advanced uses}

\item{priotirize}{(boolean) (defaut \code{TRUE}) will set priority based on pattern of execution}

\item{log}{(character) (default \code{"INFO"}) log levels as in \code{logger::log_threshold()} (c("OFF", "INFO", ...)), comes with a small performance cost}

\item{.progress}{(boolean) (default \code{TRUE}) displays a progression bar based on previous execution timings}
}
\value{
a list of r scripts (characters) executed, with timing and success and a side effect on caches
}
\description{
All scripts (passed to \code{sourcoise_refresh()}) are executed with logging enabled.
}
\details{
The function returns the list of script executed but its main effect is a side-effect as scripts are executed and caches updates accordingly.
Note also that log files reflect execution and track possible errors.
Because of logging the execution comes with a loss in performance, which is not an issue if scripts are long to execute.

It is possible to execute \code{sourcoise_refresh()} without execution forcing (\code{force_exec=FALSE}) or with it.
Forced execution means that the script is executed even if the cache is valid.
In the case of non forced execution, execution is triggered by other cache invalidation tests (change in source file, lapse or tacked files).

When scripts are linked to qmds (i.e. when run in a quarto project), it is possible to unfreeeze and uncache those qmds with the option \code{unfreeze=TRUE}.
This allows to refresh the cahe and then render the qmds using the new data.

It is possible to pass to refresh a function that will be executed before every script. This allows to load packages and declare global variables that can be used in each script.
If packages are loaded inside the script, then this is not needed.

Parameters registered ins \code{sourcoise_status()} such as \code{wd} or \code{args} are used to execute the script.

Defining a \code{priority} in \code{sourcoise()}, will change the order of execution of refresh. This can be set automatically using \code{priotirize} option.
After execution of one refresh, by setting higher priority to more used files.
}
\examples{
dir <- tempdir()
set_sourcoise_root(dir)
fs::file_copy(
   fs::path_package("sourcoise", "some_data.R"),
   dir,
   overwrite = TRUE)
# Force execution
data <- sourcoise("some_data.R", force_exec = TRUE)
# we then refresh all caches
sourcoise_refresh()
}
\seealso{
Other sourcoise: 
\code{\link{sourcoise}()},
\code{\link{sourcoise_clear}()},
\code{\link{sourcoise_clear_all}()},
\code{\link{sourcoise_reset}()},
\code{\link{sourcoise_status}()}
}
\concept{sourcoise}
