% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_form_variance_share_fun.R
\name{risk_form_variance_share_fun}
\alias{risk_form_variance_share_fun}
\title{Proportion of risk-score variance due to functional-form uncertainty}
\usage{
risk_form_variance_share_fun(all_paths_out, N, q = 0.5, eps = 1e-12)
}
\arguments{
\item{all_paths_out}{A list produced by \code{\link[=all_paths_fun]{all_paths_fun()}} with element \code{nodes}.
\code{nodes} must contain columns \code{name}, \code{cyclomatic_complexity}, \code{indeg}, and \code{btw}.}

\item{N}{Integer. Base sample size passed to \code{sensobol::sobol_matrices()}.}

\item{q}{Numeric scalar in \eqn{[0,1]}. Mixture weight giving the probability that the
functional form is \code{"power_mean"} (and \eqn{1-q} for \code{"additive"}). Default \code{0.5}.}

\item{eps}{Numeric. Small positive constant \eqn{\epsilon} used for numerical stability
in the \eqn{p \to 0} evaluation. Default \code{1e-12}.}
}
\value{
A \code{data.table} with columns:
\describe{
\item{name}{Node name.}
\item{form_variance_share}{Proportion of node-risk variance attributable to functional-form uncertainty.}
}
}
\description{
Computes, for each node, the proportion of variance in the node risk score that
is attributable to uncertainty in the \emph{functional form} used to construct the
risk score (additive vs power-mean), as opposed to uncertainty in the parameters
within a given form.
}
\details{
The function draws parameter samples for two model forms:
\itemize{
\item Additive form with weights \eqn{(\alpha,\beta,\gamma)} normalized to sum to one.
\item Power-mean form with weights \eqn{(\alpha,\beta,\gamma)} normalized to sum to one
and a power parameter \eqn{p} mapped to the interval \eqn{[-1,2]}.
}

For each node, it evaluates the risk under both forms and applies the variance
decomposition for a two-component mixture model:

\deqn{\mathrm{Var}(Y) = \mathbb{E}\left[\mathrm{Var}(Y \mid M)\right] + \mathrm{Var}\left(\mathbb{E}[Y \mid M]\right)\,,}

where \eqn{M} indicates the functional form. Let \eqn{q} be the probability of choosing
the power-mean form (and \eqn{1-q} the probability of choosing the additive form). The
between-form component is

\deqn{V_{\mathrm{between}} = q(1-q)\,(\mu_1 - \mu_0)^2\,,}

and the total variance is

\deqn{V_{\mathrm{total}} = (1-q)V_0 + qV_1 + V_{\mathrm{between}}\,,}

where \eqn{\mu_0, V_0} are the mean and variance under the additive form and
\eqn{\mu_1, V_1} are the mean and variance under the power-mean form. The reported
proportion is \eqn{V_{\mathrm{between}} / V_{\mathrm{total}}}.

This function focuses only on variance attributable to the \emph{choice of functional form}.
It does not return full uncertainty draws, Sobol sensitivity indices, or path-level
uncertainty propagation.
}
\examples{
data(synthetic_graph)
out <- all_paths_fun(graph = synthetic_graph, complexity_col = "cyclo")
vf <- risk_form_variance_share_fun(all_paths_out = out, N = 2^10, q = 0.5)
vf

}
