% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path_uncertainty_plot.R
\name{path_uncertainty_plot}
\alias{path_uncertainty_plot}
\title{Plot path-level uncertainty for the top-risk paths}
\usage{
path_uncertainty_plot(ua_sa_out, n_paths = 20)
}
\arguments{
\item{ua_sa_out}{A list returned by \code{\link[=uncertainty_fun]{uncertainty_fun()}} containing at
least an element \code{$paths}, which must be a data frame with
columns \code{path_id} and \code{uncertainty_analysis}. The column
\code{uncertainty_analysis} is expected to be a list-column where
each element is a numeric vector of path risk values obtained from
Monte Carlo sampling.}

\item{n_paths}{Integer, number of top paths (by mean risk) to include
in the plot. Defaults to 20.}
}
\value{
A \pkg{ggplot2} object.
}
\description{
Plot the top \code{n_paths} paths ranked by their mean risk score,
with horizontal error bars representing the uncertainty range
(minimum and maximum risk) computed from the Monte Carlo samples
stored in \code{uncertainty_analysis}.
}
\details{
This function is designed to work with the \code{paths} component of
the output of \code{\link[=uncertainty_fun]{uncertainty_fun()}}. For each path, it summarises the
vector of path risk values by computing the mean, minimum and maximum values, and then displays
these summaries for the \code{n_paths} most risky paths.
}
\examples{
\donttest{
data(synthetic_graph)
out <- all_paths_fun(graph = synthetic_graph, alpha = 0.6, beta = 0.3,
gamma = 0.1, complexity_col = "cyclo")
results <- uncertainty_fun(all_paths_out = out, N = 2^10, order = "first")
path_uncertainty_plot(ua_sa_out = results, n_paths = 20)
}
}
