% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readdesign.R
\name{readdesign}
\alias{readdesign}
\title{Creates a dataframe with the design.}
\usage{
readdesign(design = designfile, designtype = NULL, destype = NULL)
}
\arguments{
\item{design}{The path to a design file}

\item{designtype}{Is it a design created with ngene, spdesign or idefix. use 'ngene', 'spdesign' or 'idefix. Ngene designs should be stored as the standard .ngd output. spdesign should be the spdesign object stored as an RDS file. Idefix objects should also be stored as an RDS file. If designtype is not specified, I try to guess what it is. This is especially helpful if you want to carry out a simulation for both spdesign designs and ngene designs at the same time.}

\item{destype}{Deprecated. Use designtype instead.}
}
\value{
a dataframe
}
\description{
Creates a dataframe with the design.
}
\examples{
library(simulateDCE)
mydesign <- readdesign(
  system.file("extdata", "agora", "altscf_eff.ngd", package = "simulateDCE"),
  "ngene"
)

print(mydesign)

}
